/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jwicket.ui.dragdrop;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptContentHeaderItem;

public class DraggablesAcceptedByDroppable
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DRAG_NAME_IDENTIFIER = "dragClass";
    private static final String functionPrefix = "wicketJQeryDropAccessTester";
    private static int nextId = 0;
    private final String id;
    private List<String> acceptedNames = new ArrayList<String>();

    public DraggablesAcceptedByDroppable(String ... names) {
        this.id = functionPrefix + String.valueOf(nextId++);
        for (String name : names) {
            if (name == null || this.acceptedNames.contains(name)) continue;
            this.acceptedNames.add(name);
        }
    }

    public void addName(String name) {
        if (name != null && !this.acceptedNames.contains(name)) {
            this.acceptedNames.add(name);
        }
    }

    public void removeName(String name) {
        if (name != null) {
            this.acceptedNames.remove(name);
        }
    }

    public int size() {
        return this.acceptedNames.size();
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    private String getTypesAsJsSet() {
        if (this.acceptedNames.size() > 10) {
            StringBuilder sb = new StringBuilder("[");
            boolean first = true;
            for (String s : this.acceptedNames) {
                if (!first) {
                    sb.append(",");
                } else {
                    first = false;
                }
                sb.append("'");
                sb.append(s);
                sb.append("'");
            }
            sb.append("]");
            return sb.toString();
        }
        Object jsSet = "[";
        boolean first = true;
        for (String s : this.acceptedNames) {
            if (!first) {
                jsSet = (String)jsSet + ",";
            } else {
                first = false;
            }
            jsSet = (String)jsSet + "'";
            jsSet = (String)jsSet + s;
            jsSet = (String)jsSet + "'";
        }
        jsSet = (String)jsSet + "]";
        return ((String)jsSet).toString();
    }

    public String getJsAcceptCheckerFunctionName() {
        return this.id;
    }

    public void renderJsDropAcceptFunction(IHeaderResponse response) {
        if (this.acceptedNames != null && this.acceptedNames.size() > 0) {
            response.render((HeaderItem)JavaScriptContentHeaderItem.forScript((CharSequence)("var " + this.getJsAcceptCheckerFunctionName() + " = function(candidate) {\n\tvar accepted = " + this.getTypesAsJsSet() + ";\n\tvar candidateString = jQuery(candidate).attr('dragClass');\n\tfor (var i = 0; i < accepted.length; i++)\n\t\tif (accepted[i] == candidateString)\n\t\t\treturn true;\treturn false;};"), (String)this.id));
        } else {
            response.render((HeaderItem)JavaScriptContentHeaderItem.forScript((CharSequence)("var " + this.getJsAcceptCheckerFunctionName() + " = function(candidate) {\n\treturn false;};"), (String)this.id));
        }
    }
}

