/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jwicket.ui.dragdrop;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.Request;
import org.apache.wicket.util.visit.IVisitor;
import org.wicketstuff.jwicket.ComponentFinder;
import org.wicketstuff.jwicket.JQuery;
import org.wicketstuff.jwicket.JQueryAjaxBehavior;
import org.wicketstuff.jwicket.JQueryResourceReference;
import org.wicketstuff.jwicket.JsMap;
import org.wicketstuff.jwicket.SpecialKeys;
import org.wicketstuff.jwicket.ui.AbstractJqueryUiEmbeddedBehavior;
import org.wicketstuff.jwicket.ui.dragdrop.AbstractDragDropBehavior;
import org.wicketstuff.jwicket.ui.dragdrop.DraggableBehavior;
import org.wicketstuff.jwicket.ui.dragdrop.DraggablesAcceptedByDroppable;
import org.wicketstuff.jwicket.ui.dragdrop.IDroppable;

public class DroppableBehavior
extends AbstractDragDropBehavior {
    private static final long serialVersionUID = 1L;
    private static final String DROPPED_COMPONENTID_IDENTIFIER = "wsjqDroppedComponent";
    public static final JQueryResourceReference uiDroppableJs = JQuery.isDebug() ? new JQueryResourceReference(DraggableBehavior.class, "jquery.ui.droppable.js") : new JQueryResourceReference(DraggableBehavior.class, "jquery.ui.droppable.min.js");
    private JsMap options = new JsMap();
    private DraggablesAcceptedByDroppable draggablesAcceptedByDroppable = null;
    private boolean dropAcceptedCheckerRendered = false;
    private boolean onActivatedNotificationWanted = false;
    private boolean onDeactivateNotificationWanted = false;

    public DroppableBehavior() {
        super(AbstractJqueryUiEmbeddedBehavior.jQueryUiWidgetJs, AbstractJqueryUiEmbeddedBehavior.jQueryUiMouseJs, DraggableBehavior.jQueryUiDraggableJs, uiDroppableJs, SpecialKeys.specialKeysJs);
    }

    public DroppableBehavior setWantOnActivatedNotification(boolean value) {
        this.onActivatedNotificationWanted = value;
        return this;
    }

    public DroppableBehavior setWantOnDeactivateNotification(boolean value) {
        this.onDeactivateNotificationWanted = value;
        return this;
    }

    public DroppableBehavior setDraggablesAcceptedByDroppable(DraggablesAcceptedByDroppable accepted) {
        this.draggablesAcceptedByDroppable = accepted;
        if (accepted != null) {
            this.options.put((Object)"accept", (Object)new JQueryAjaxBehavior.JsFunction(accepted.getJsAcceptCheckerFunctionName()));
        } else {
            this.options.remove((Object)"accept");
        }
        return this;
    }

    public DroppableBehavior setActiveClass(String activeClass) {
        if (activeClass == null) {
            this.options.remove((Object)"activeClass");
        } else {
            this.options.put((Object)"activeClass", (Object)activeClass);
        }
        return this;
    }

    public DroppableBehavior setActiveClass(AjaxRequestTarget target, String activeClass) {
        this.setActiveClass(activeClass);
        if (activeClass != null) {
            target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').droppable('option','activeClass','" + activeClass + "');"));
        } else {
            target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').droppable('option','activeClass',false);"));
        }
        return this;
    }

    public DroppableBehavior setAddClasses(boolean value) {
        if (value) {
            this.options.remove((Object)"addClasses");
        } else {
            this.options.put((Object)"addClasses", (Object)value);
        }
        return this;
    }

    public DroppableBehavior setAddClasses(AjaxRequestTarget target, boolean value) {
        this.setAddClasses(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').droppable('option','addClasses'," + value + ");"));
        return this;
    }

    public DroppableBehavior setGreedy(boolean value) {
        if (value) {
            this.options.remove((Object)"greedy");
        } else {
            this.options.put((Object)"greedy", (Object)value);
        }
        return this;
    }

    public DroppableBehavior setGreedy(AjaxRequestTarget target, boolean value) {
        this.setGreedy(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').droppable('option','greedy'," + value + ");"));
        return this;
    }

    public DroppableBehavior setHoverClass(String hoverClass) {
        if (hoverClass == null) {
            this.options.remove((Object)"hoverClass");
        } else {
            this.options.put((Object)"hoverClass", (Object)hoverClass);
        }
        return this;
    }

    public DroppableBehavior setHoverClass(AjaxRequestTarget target, String hoverClass) {
        this.setHoverClass(hoverClass);
        if (hoverClass != null) {
            target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').droppable('option','hoverClass','" + hoverClass + "');"));
        } else {
            target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').droppable('option','hoverClass',false);"));
        }
        return this;
    }

    public DroppableBehavior setScope(String scope) {
        if (scope == null) {
            this.options.remove((Object)"scope");
        } else {
            this.options.put((Object)"scope", (Object)scope);
        }
        return this;
    }

    public DroppableBehavior setScope(AjaxRequestTarget target, String scope) {
        this.setScope(scope);
        if (scope != null) {
            target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').droppable('option','scope','" + scope + "');"));
        } else {
            target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').droppable('option','scope','default');"));
        }
        return this;
    }

    public DroppableBehavior setTolerance(DropTolerance tolerance) {
        if (tolerance == null) {
            this.options.remove((Object)"tolerance");
        } else {
            this.options.put((Object)"tolerance", (Object)tolerance.getValue());
        }
        return this;
    }

    public DroppableBehavior setScope(AjaxRequestTarget target, DropTolerance tolerance) {
        this.setTolerance(tolerance);
        if (tolerance != null) {
            target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').droppable('option','tolerance','" + tolerance.getValue() + "');"));
        } else {
            target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').droppable('option','tolerance','" + DropTolerance.INTERSECT + "');"));
        }
        return this;
    }

    protected void respond(AjaxRequestTarget target) {
        Request request;
        Component component = this.getComponent();
        if (component != null && (request = component.getRequest()) != null) {
            AbstractDragDropBehavior.EventType dragEventType = AbstractDragDropBehavior.EventType.stringToType(request.getRequestParameters().getParameterValue("wicketDragDropEvent").toString());
            IVisitor<Component, Component> visitor = this.getComponentFindingVisitor(request.getRequestParameters().getParameterValue(DROPPED_COMPONENTID_IDENTIFIER).toString());
            Component foundComponent = (Component)component.getPage().visitChildren(visitor);
            if (component instanceof IDroppable) {
                IDroppable draggableComponent = (IDroppable)component;
                if (dragEventType == AbstractDragDropBehavior.EventType.DROP) {
                    draggableComponent.onDrop(target, foundComponent, new SpecialKeys(request));
                } else if (dragEventType == AbstractDragDropBehavior.EventType.DROP_ACTIVATE) {
                    draggableComponent.onActivate(target, foundComponent, new SpecialKeys(request));
                } else if (dragEventType == AbstractDragDropBehavior.EventType.DROP_DEACTIVATE) {
                    draggableComponent.onDeactivate(target, foundComponent, new SpecialKeys(request));
                }
            }
            if (dragEventType == AbstractDragDropBehavior.EventType.DROP) {
                this.onDrop(target, foundComponent, new SpecialKeys(request));
            } else if (dragEventType == AbstractDragDropBehavior.EventType.DROP_ACTIVATE) {
                this.onActivate(target, foundComponent, new SpecialKeys(request));
            } else if (dragEventType == AbstractDragDropBehavior.EventType.DROP_DEACTIVATE) {
                this.onDeactivate(target, foundComponent, new SpecialKeys(request));
            }
        }
    }

    protected IVisitor<Component, Component> getComponentFindingVisitor(String markupId) {
        return new ComponentFinder(markupId);
    }

    protected void onDrop(AjaxRequestTarget target, Component draggedComponent, SpecialKeys specialKeys) {
    }

    protected void onActivate(AjaxRequestTarget target, Component draggedComponent, SpecialKeys specialKeys) {
    }

    protected void onDeactivate(AjaxRequestTarget target, Component draggedComponent, SpecialKeys specialKeys) {
    }

    public void disable(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').droppable('disable');"));
    }

    public void enable(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').droppable('enable');"));
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        if (this.draggablesAcceptedByDroppable != null && !this.dropAcceptedCheckerRendered) {
            this.draggablesAcceptedByDroppable.renderJsDropAcceptFunction(response);
            this.dropAcceptedCheckerRendered = true;
        }
    }

    protected JQueryAjaxBehavior.JsBuilder getJsBuilder() {
        if (this.onDeactivateNotificationWanted) {
            this.options.put((Object)"deactivate", (Object)new JQueryAjaxBehavior.JsFunction("function(ev,ui) { \nwicketAjaxGet('" + this.getCallbackUrl() + "&wicketDragDropEvent=" + AbstractDragDropBehavior.EventType.DROP_DEACTIVATE + "&wsjqDroppedComponent='+jQuery(ui.draggable).attr('id')+'&keys='+jQuery.jWicketSpecialKeysGetPressed()); }"));
        }
        this.options.put((Object)"drop", (Object)new JQueryAjaxBehavior.JsFunction("function(ev,ui) { \nwicketAjaxGet('" + this.getCallbackUrl() + "&wicketDragDropEvent=" + AbstractDragDropBehavior.EventType.DROP + "&wsjqDroppedComponent='+jQuery(ui.draggable).attr('id')+'&keys='+jQuery.jWicketSpecialKeysGetPressed()); }"));
        if (this.onActivatedNotificationWanted) {
            this.options.put((Object)"activate", (Object)new JQueryAjaxBehavior.JsFunction("function(ev,ui) { \nwicketAjaxGet('" + this.getCallbackUrl() + "&wicketDragDropEvent=" + AbstractDragDropBehavior.EventType.DROP_ACTIVATE + "&wsjqDroppedComponent='+jQuery(ui.draggable).attr('id')+'&keys='+jQuery.jWicketSpecialKeysGetPressed()); }"));
        }
        JQueryAjaxBehavior.JsBuilder builder = new JQueryAjaxBehavior.JsBuilder();
        builder.append((Object)("jQuery('#" + this.getComponent().getMarkupId() + "').droppable("));
        builder.append((Object)"{");
        builder.append((Object)this.options.toString(this.rawOptions));
        builder.append((Object)"}");
        builder.append((Object)");");
        return builder;
    }

    public static enum DropTolerance {
        FTI("fit"),
        INTERSECT("intersect"),
        POINTER("pointer"),
        TOUCH("touch");

        private final String value;

        private DropTolerance(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

