/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jwicket.ui.effect;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.wicketstuff.jwicket.JQuery;
import org.wicketstuff.jwicket.JQueryHeaderContributor;
import org.wicketstuff.jwicket.JQueryResourceReference;
import org.wicketstuff.jwicket.JQuerySpeed;

public abstract class AbstractJqueryUiEffect
extends JQueryHeaderContributor {
    private static final long serialVersionUID = 1L;
    private static long nextId = 0L;
    public static final JQueryResourceReference jQueryUiEffectsCoreJs = JQuery.isDebug() ? new JQueryResourceReference(AbstractJqueryUiEffect.class, "jquery.effects.core.js") : new JQueryResourceReference(AbstractJqueryUiEffect.class, "jquery.effects.core.min.js");
    protected boolean restoreStyleAfterEffect = true;
    protected String speed = null;
    protected String effectClass = null;
    protected String fadeInAfter = null;
    private String varNameElement;
    private String varNameStyle;
    private String varNameClass;

    public AbstractJqueryUiEffect(JQueryResourceReference ... requiredLibraries) {
        super(jQueryUiEffectsCoreJs, requiredLibraries);
    }

    public AbstractJqueryUiEffect setRestoreStyleAfterEffect(boolean value) {
        this.restoreStyleAfterEffect = value;
        return this;
    }

    public AbstractJqueryUiEffect setSpeed(JQuerySpeed value) {
        this.speed = value == null ? null : "'" + value.getSpeed() + "'";
        return this;
    }

    public AbstractJqueryUiEffect setSpeed(int ms) {
        this.speed = ms <= 0 ? null : String.valueOf(ms);
        return this;
    }

    public void setEffectClass(String value) {
        this.effectClass = value;
    }

    public String getEffectClass() {
        return this.effectClass;
    }

    public AbstractJqueryUiEffect setFadeInAfter(int speed) {
        this.fadeInAfter = speed <= 0 ? null : String.valueOf(speed);
        return this;
    }

    public AbstractJqueryUiEffect setFadeInAfter(JQuerySpeed speed) {
        this.fadeInAfter = speed == null ? null : "'" + speed.getSpeed() + "'";
        return this;
    }

    abstract String getEffectName();

    abstract void appendOptions(StringBuilder var1);

    private void prepare(StringBuilder jsString, AbstractJqueryUiEffect firstEffect, List<AbstractJqueryUiEffect> chain) {
        if (firstEffect == null && (chain == null || chain.size() == 0)) {
            if (this.restoreStyleAfterEffect) {
                jsString.append(this.varNameElement);
                jsString.append(".attr('style',");
                jsString.append(this.varNameStyle);
                jsString.append(");");
                jsString.append(this.varNameStyle);
                jsString.append("=null;");
            }
            jsString.append(this.varNameElement);
            jsString.append("=null;");
            return;
        }
        AbstractJqueryUiEffect currentEffect = firstEffect;
        if (currentEffect == null) {
            currentEffect = chain.get(0);
        }
        if (currentEffect.getEffectClass() != null) {
            jsString.append("var ");
            jsString.append(this.varNameClass);
            jsString.append("=");
            jsString.append(this.varNameElement);
            jsString.append(".attr('class');");
            jsString.append(this.varNameElement);
            jsString.append(".attr('class','");
            jsString.append(currentEffect.getEffectClass());
            jsString.append("');");
        }
        jsString.append(this.varNameElement);
        jsString.append(".effect('");
        jsString.append(currentEffect.getEffectName());
        jsString.append("'");
        currentEffect.appendOptions(jsString);
        if (this.speed != null) {
            jsString.append(",");
            jsString.append(this.speed);
        }
        jsString.append(",function(){");
        if (currentEffect.getEffectClass() != null) {
            jsString.append(this.varNameElement);
            jsString.append(".attr('class',");
            jsString.append(this.varNameClass);
            jsString.append(");");
            jsString.append(this.varNameClass);
            jsString.append("=null;");
        }
        if (currentEffect.fadeInAfter != null) {
            jsString.append(this.varNameElement);
            jsString.append(".fadeIn(");
            jsString.append(currentEffect.fadeInAfter);
            jsString.append(");");
        }
        if (chain != null || firstEffect != null && chain == null) {
            if (firstEffect != null) {
                this.prepare(jsString, null, chain);
            } else {
                this.prepare(jsString, null, chain.subList(1, chain.size()));
            }
        }
        jsString.append("}");
        jsString.append(");");
    }

    public void fire(AjaxRequestTarget target, Component ... components) {
        this.fire(target, (List<AbstractJqueryUiEffect>)null, components);
    }

    public void fire(AjaxRequestTarget target, AbstractJqueryUiEffect postEffect, Component ... components) {
        ArrayList<AbstractJqueryUiEffect> postEffects = new ArrayList<AbstractJqueryUiEffect>(1);
        postEffects.add(postEffect);
        this.fire(target, postEffects, components);
    }

    public void fire(AjaxRequestTarget target, List<AbstractJqueryUiEffect> postEffects, Component ... components) {
        if (components == null) {
            return;
        }
        StringBuilder jsString = new StringBuilder();
        for (Component component : components) {
            if (component == null) continue;
            if (component.getOutputMarkupId()) {
                this.varNameElement = "effectElement" + nextId;
                this.varNameStyle = "originalStyle" + nextId;
                this.varNameClass = "originalClass" + nextId;
                ++nextId;
                jsString.append("{var ");
                jsString.append(this.varNameElement);
                jsString.append("=jQuery('#");
                jsString.append(component.getMarkupId());
                jsString.append("');");
                if (this.restoreStyleAfterEffect) {
                    jsString.append("var ");
                    jsString.append(this.varNameStyle);
                    jsString.append("=");
                    jsString.append(this.varNameElement);
                    jsString.append(".attr('style');");
                }
                this.prepare(jsString, this, postEffects);
                jsString.append("}");
                continue;
            }
            throw new WicketRuntimeException("You must not fire a jQuery effet on a component wich hast not set output markupId to true! Component: " + component);
        }
        target.appendJavaScript((CharSequence)jsString.toString());
    }
}

