/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jwicket.ui.effect;

import org.wicketstuff.jwicket.JQuery;
import org.wicketstuff.jwicket.JQueryResourceReference;
import org.wicketstuff.jwicket.ui.effect.AbstractJqueryUiEffect;
import org.wicketstuff.jwicket.ui.effect.Blind;
import org.wicketstuff.jwicket.ui.effect.EffectDirection;

public class Bounce
extends AbstractJqueryUiEffect {
    private static final long serialVersionUID = 1L;
    public static final JQueryResourceReference jQueryUiEffectsBounceJs = JQuery.isDebug() ? new JQueryResourceReference(Blind.class, "jquery.effects.bounce.js") : new JQueryResourceReference(Blind.class, "jquery.effects.bounce.min.js");
    private String mode = null;
    private String direction = null;
    private String distance = null;
    private String times = null;

    public Bounce() {
        super(jQueryUiEffectsBounceJs);
    }

    @Override
    String getEffectName() {
        return "bounce";
    }

    public Bounce setMode(BounceMode value) {
        this.mode = value == null ? null : value.getMode();
        return this;
    }

    public Bounce setDirection(EffectDirection value) {
        this.direction = value == null ? null : value.getDirection();
        return this;
    }

    public Bounce setDistance(int value) {
        this.distance = value <= 0 ? null : String.valueOf(value);
        return this;
    }

    public Bounce setTimes(int value) {
        this.times = value <= 0 ? null : String.valueOf(value);
        return this;
    }

    @Override
    void appendOptions(StringBuilder jsString) {
        if (this.mode != null || this.direction != null || this.distance != null || this.times != null) {
            boolean firstOption = true;
            jsString.append(",{");
            if (this.mode != null) {
                jsString.append("mode:'");
                jsString.append(this.mode);
                jsString.append("'");
                firstOption = false;
            }
            if (this.direction != null) {
                if (!firstOption) {
                    jsString.append(",");
                }
                jsString.append("direction:'");
                jsString.append(this.direction);
                jsString.append("'");
                firstOption = false;
            }
            if (this.distance != null) {
                if (!firstOption) {
                    jsString.append(",");
                }
                jsString.append("distance:");
                jsString.append(this.distance);
                firstOption = false;
            }
            if (this.times != null) {
                if (!firstOption) {
                    jsString.append(",");
                }
                jsString.append("times:");
                jsString.append(this.times);
            }
            jsString.append("}");
        }
    }

    public static enum BounceMode {
        DEFAULT(null),
        SHOW("show"),
        HIDE("hide"),
        EFFECT("effect");

        private final String mode;

        private BounceMode(String mode) {
            this.mode = mode;
        }

        public String getMode() {
            return this.mode;
        }

        public String toString() {
            return this.mode == null ? "default" : this.mode;
        }
    }
}

