/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.logback;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public abstract class AbstractWebFormattingConverter
extends ClassicConverter {
    public static final String RA_WEB_INFO = AbstractWebFormattingConverter.class.getName() + ".RA_WEB_INFO";

    public String convert(ILoggingEvent event) {
        String webString = this.getWebString();
        return webString == null ? "" : webString;
    }

    protected String getWebString() {
        HttpServletRequest request = this.getRequest();
        if (request == null) {
            return null;
        }
        Object raAttribute = request.getAttribute(RA_WEB_INFO);
        if (raAttribute != null) {
            return raAttribute.toString();
        }
        HttpSession session = request.getSession(false);
        String webString = request.getMethod() + " " + request.getRequestURL() + "?" + request.getQueryString() + " " + (session != null ? session.getId() : null) + " " + request.getRemoteUser() + " " + request.getRemoteAddr() + ":" + request.getRemotePort() + " " + request.getLocalAddr() + ":" + request.getLocalPort() + " " + request.getHeader("X-Forwarded-For") + " " + request.getHeader("User-Agent");
        request.setAttribute(RA_WEB_INFO, (Object)webString);
        return webString;
    }

    protected abstract HttpServletRequest getRequest();
}

