/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguratorPage
extends WebPage {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ConfiguratorPage.class);
    private static final List<Level> LEVELS = Arrays.asList(Level.WARN, Level.DEBUG, Level.TRACE, Level.INFO, Level.ERROR, Level.ALL);

    public ConfiguratorPage(PageParameters parameters) {
        super(parameters);
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        List loggers = context.getLoggerList();
        final FeedbackPanel feedback = new FeedbackPanel("feedback");
        feedback.setOutputMarkupId(true);
        final DropDownChoice loggersDDC = new DropDownChoice("loggers", (IModel)Model.of((Serializable)((ch.qos.logback.classic.Logger)null)), loggers);
        Collections.sort(LEVELS, new Comparator<Level>(){

            @Override
            public int compare(Level o1, Level o2) {
                return o1.levelInt > o2.levelInt ? 1 : -1;
            }
        });
        final DropDownChoice levelsDDC = new DropDownChoice("levels", (IModel)Model.of((Serializable)((Level)null)), LEVELS);
        levelsDDC.setOutputMarkupId(true);
        this.add(new Component[]{feedback, loggersDDC, levelsDDC});
        loggersDDC.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                ch.qos.logback.classic.Logger log = (ch.qos.logback.classic.Logger)loggersDDC.getModelObject();
                Level level = log.getEffectiveLevel();
                levelsDDC.setModelObject((Object)level);
                logger.debug("Logger '{}' has level '{}'.", (Object)log.getName(), (Object)level);
                target.add(new Component[]{levelsDDC});
            }
        }});
        levelsDDC.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                Level level = (Level)levelsDDC.getModelObject();
                ch.qos.logback.classic.Logger log = (ch.qos.logback.classic.Logger)loggersDDC.getModelObject();
                log.setLevel(level);
                logger.debug("Logger '{}' now has level '{}'.", (Object)log.getName(), (Object)level);
                ConfiguratorPage.this.info((Serializable)((Object)("Logger on '" + log.getName() + "' has been set to '" + level.toString() + "'")));
                target.add(new Component[]{levelsDDC, feedback});
            }
        }});
    }
}

