/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class LogbackConfigListener
implements ServletContextListener {
    public static final String CONFIG_LOCATION_PARAM = "logbackConfigLocation";
    public static final String CONFIG_CONTEXT_PATH_KEY_PARAM = "logbackConfigContextPathKey";
    public static final String CONTEXT_PATH_ROOT_VAL = "ROOT";
    public static final String LOCATION_PREFIX_CLASSPATH = "classpath:";

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext sc = sce.getServletContext();
        ILoggerFactory ilc = LoggerFactory.getILoggerFactory();
        if (!(ilc instanceof LoggerContext)) {
            sc.log("Can not configure logback. " + LoggerFactory.class + " is using " + ilc + " which is not an instance of " + LoggerContext.class);
            return;
        }
        LoggerContext lc = (LoggerContext)ilc;
        this.applyConfigLocation(sc, lc);
    }

    protected void applyConfigLocation(ServletContext sc, LoggerContext lc) {
        String contextPathKey = sc.getInitParameter(CONFIG_CONTEXT_PATH_KEY_PARAM);
        String rawLocation = sc.getInitParameter(CONFIG_LOCATION_PARAM);
        String location = rawLocation;
        if (location != null) {
            location = OptionHelper.substVars((String)location, (PropertyContainer)lc);
        }
        if (location == null) {
            if (rawLocation != null) {
                sc.log("Can not configure logback. Location is null after substitution. Maybe context param \"logbackConfigLocation\" is not set correctly.");
            }
            return;
        }
        URL url = this.toUrl(sc, location);
        if (url == null) {
            sc.log("Can not configure logback. Could not find logback config neither as servlet context-, nor as classpath-, nor as url-, nor as file system resource. Config location = \"" + location + "\".");
            return;
        }
        sc.log("Configuring logback. Config location = \"" + location + "\", full url = \"" + url + "\"." + (contextPathKey != null ? " Context path will be added to the logback properties with key = \"" + contextPathKey + "\"." : ""));
        this.configureConfig(sc, lc, url, contextPathKey);
    }

    protected void configureConfig(ServletContext sc, LoggerContext lc, URL location, String contextPathKey) {
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        lc.stop();
        if (contextPathKey != null) {
            lc.putProperty(contextPathKey, this.getContextPath(sc));
        }
        try {
            configurator.doConfigure(location);
        }
        catch (JoranException e) {
            sc.log("Failed to configure logback.", (Throwable)e);
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)lc);
    }

    protected String getContextPath(ServletContext sc) {
        String cp = sc.getContextPath();
        if (cp.startsWith("/")) {
            cp = cp.substring(1);
        }
        if ("".equals(cp)) {
            cp = CONTEXT_PATH_ROOT_VAL;
        }
        return cp;
    }

    protected URL toUrl(ServletContext sc, String location) {
        URL url = null;
        if (location.startsWith("/")) {
            try {
                url = sc.getResource(location);
            }
            catch (MalformedURLException e1) {
                // empty catch block
            }
        }
        if (url == null && location.startsWith(LOCATION_PREFIX_CLASSPATH)) {
            url = Thread.currentThread().getContextClassLoader().getResource(location.substring(LOCATION_PREFIX_CLASSPATH.length()));
        }
        if (url == null) {
            try {
                url = new URL(location);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (url == null) {
            File file = new File(location);
            if (!file.isAbsolute()) {
                file = file.getAbsoluteFile();
            }
            if (file.isFile()) {
                try {
                    url = file.toURI().normalize().toURL();
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
        return url;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ILoggerFactory ilc = LoggerFactory.getILoggerFactory();
        if (!(ilc instanceof LoggerContext)) {
            return;
        }
        LoggerContext lc = (LoggerContext)ilc;
        lc.stop();
    }
}

