/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.behavior.apanel;

import org.wicketstuff.minis.behavior.apanel.ConstraintBehavior;

public class GridLayoutConstraint
extends ConstraintBehavior
implements Comparable<GridLayoutConstraint> {
    private static final long serialVersionUID = 1L;
    private final int col;
    private final int row;
    private int colSpan = 1;
    private int rowSpan = 1;

    public GridLayoutConstraint(int col, int row) {
        this.col = col;
        this.row = row;
    }

    @Override
    public int compareTo(GridLayoutConstraint constraint) {
        if (this.getRow() > constraint.getRow()) {
            return 1;
        }
        if (this.getRow() < constraint.getRow()) {
            return -1;
        }
        if (this.getCol() > constraint.getCol()) {
            return 1;
        }
        if (this.getCol() < constraint.getCol()) {
            return -1;
        }
        return 0;
    }

    boolean contains(int col, int row) {
        return col >= this.getCol() && col < this.getCol() + this.getColSpan() && row >= this.getRow() && row < this.getRow() + this.getRowSpan();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridLayoutConstraint that = (GridLayoutConstraint)o;
        return this.col == that.col && this.row == that.row;
    }

    public int getCol() {
        return this.col;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public int getRow() {
        return this.row;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public int hashCode() {
        int result = this.col;
        result = 31 * result + this.row;
        return result;
    }

    boolean intersectsWith(GridLayoutConstraint constraint) {
        for (int col = constraint.getCol(); col < constraint.getCol() + constraint.getColSpan(); ++col) {
            for (int row = constraint.getRow(); row < constraint.getRow() + constraint.getRowSpan(); ++row) {
                if (!this.contains(col, row)) continue;
                return true;
            }
        }
        return false;
    }

    public GridLayoutConstraint setColSpan(int colSpan) {
        if (colSpan < 1) {
            throw new IllegalArgumentException("colspan can't be zero or negative : " + colSpan);
        }
        this.colSpan = colSpan;
        return this;
    }

    public GridLayoutConstraint setRowSpan(int rowSpan) {
        if (rowSpan < 1) {
            throw new IllegalArgumentException("rowspan can't be zero or negative : " + rowSpan);
        }
        this.rowSpan = rowSpan;
        return this;
    }

    public String toString() {
        return String.format("[%s, %s, %s, %s]", this.col, this.row, this.colSpan, this.rowSpan);
    }
}

