/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.behavior.mootip;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.template.PackageTextTemplate;
import org.apache.wicket.util.template.TextTemplate;
import org.wicketstuff.minis.behavior.mootip.MootipAjaxListener;
import org.wicketstuff.minis.behavior.mootip.MootipPanel;
import org.wicketstuff.minis.behavior.mootip.MootipSettings;

public class MootipBehaviour
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final TextTemplate mooTipTemplate = new PackageTextTemplate(MootipBehaviour.class, "MootipBehaviour.js");
    private MootipSettings mootipSettings = new MootipSettings();
    private Component component;
    private boolean addTitle = false;
    private String content = "";
    private String title = "";
    private boolean ajax = false;
    private MootipPanel panel = null;
    private boolean contributeCSS = true;

    public MootipBehaviour(MootipPanel panel) {
        this.ajax = true;
        this.panel = panel;
    }

    public MootipBehaviour(MootipPanel panel, boolean contribute) {
        this(panel);
        this.contributeCSS = contribute;
    }

    public MootipBehaviour(String title, String content) {
        this.addTitle = true;
        this.content = content;
        this.title = title;
    }

    public MootipBehaviour(String title, String content, boolean contribute) {
        this(title, content);
        this.contributeCSS = contribute;
    }

    public void bind(Component component) {
        super.bind(component);
        this.component = component;
        this.component.setOutputMarkupId(true);
        if (this.addTitle && !this.isAjax()) {
            component.add(new Behavior[]{AttributeModifier.replace((String)"title", (Serializable)((Object)(this.title + "::" + this.content)))});
        }
        if (this.isAjax()) {
            this.component.add(new Behavior[]{new MootipAjaxListener(this.panel)});
            component.add(new Behavior[]{AttributeModifier.replace((String)"title", (Serializable)((Object)("CALLBACK:mootipAjax" + this.getEscapedComponentMarkupId() + "()")))});
        }
        component.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)("toolTipImg" + this.getEscapedComponentMarkupId())))});
        component.setOutputMarkupId(true);
    }

    private String generateJS(TextTemplate textTemplate) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        String widgetId = this.getEscapedComponentMarkupId();
        variables.put("id", widgetId);
        variables.put("widgetId", ".toolTipImg" + this.getEscapedComponentMarkupId());
        variables.put("maxTitleChars", this.mootipSettings.getMaxTitleChars());
        variables.put("evalAlways", this.mootipSettings.isEvalAlways());
        variables.put("showOnClick", this.mootipSettings.isShowOnClick());
        variables.put("showOnMouseEnter", this.mootipSettings.isShowOnMouseEnter());
        variables.put("showDelay", this.mootipSettings.getShowDelay());
        variables.put("hideDelay", this.mootipSettings.getHideDelay());
        variables.put("className", this.mootipSettings.getClassName());
        variables.put("offsetX", Math.round(this.mootipSettings.getOffsets().getX()));
        variables.put("offsetY", Math.round(this.mootipSettings.getOffsets().getY()));
        variables.put("fixed", this.mootipSettings.isFixed());
        textTemplate.interpolate(variables);
        return textTemplate.asString();
    }

    protected final String getEscapedComponentMarkupId() {
        return this.component.getMarkupId().replaceAll("\\W", "");
    }

    public boolean isAjax() {
        return this.ajax;
    }

    public void renderHead(Component c, IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new PackageResourceReference(MootipBehaviour.class, "mootools.v1.11.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new PackageResourceReference(MootipBehaviour.class, "mootips.v1.11.js")));
        if (this.contributeCSS) {
            response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new PackageResourceReference(MootipBehaviour.class, "tip.css")));
        }
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)this.generateJS(this.mooTipTemplate)));
    }

    public void setMootipSettings(MootipSettings mootipSettings) {
        this.mootipSettings = mootipSettings;
    }
}

