/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.mapper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.core.request.mapper.PackageMapper;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.AbstractMapper;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.PackageName;

public class ExtendedPackageMapper
extends AbstractMapper {
    private PackageMapper mountedMapper;
    private String mountedPath;
    private String[] mountedSegments;
    private String packageName;
    private String homePageName;

    public <P extends Page> ExtendedPackageMapper(String mountPath, Class<P> homePage) {
        this.homePageName = homePage.getSimpleName();
        this.mountedPath = mountPath;
        this.mountedSegments = this.getMountSegments(this.mountedPath);
        PackageName pkgNameObj = PackageName.forClass(homePage);
        this.packageName = pkgNameObj.getName();
        this.mountedMapper = new PackageMapper(this.packageName, pkgNameObj);
    }

    public Url mapHandler(IRequestHandler requestHandler) {
        Url url = this.mountedMapper.mapHandler(requestHandler);
        if (url != null) {
            ArrayList<String> newUrlSegments = new ArrayList<String>(this.mountedSegments.length);
            String[] stringArray = this.mountedSegments;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String segment;
                String newSegment = segment = stringArray[i];
                String placeholder = this.getPlaceholder(segment);
                if (placeholder != null) {
                    newSegment = url.getQueryParameter(placeholder).getValue();
                    url.removeQueryParameters(placeholder);
                }
                newUrlSegments.add(newSegment);
            }
            List urlSegments = url.getSegments();
            urlSegments.remove(0);
            urlSegments.addAll(0, newUrlSegments);
            int lastIndex = urlSegments.size() - 1;
            if (((String)urlSegments.get(lastIndex)).equals(this.homePageName)) {
                urlSegments.remove(lastIndex);
            }
        }
        return url;
    }

    protected boolean validateParameters(PageParameters parameters) {
        return true;
    }

    public IRequestHandler mapRequest(Request request) {
        Url url = request.getUrl();
        List urlSegments = url.getSegments();
        int countUrlSegments = urlSegments.size();
        if (countUrlSegments < this.mountedSegments.length) {
            return null;
        }
        PageParameters mountedParameters = new PageParameters();
        int i = 0;
        Iterator urlSegmentsIterator = urlSegments.iterator();
        for (String mountedSegment : this.mountedSegments) {
            if (i == countUrlSegments) break;
            String urlSegmentValue = (String)urlSegmentsIterator.next();
            String name = this.getPlaceholder(mountedSegment);
            if (name != null) {
                mountedParameters.add(name, (Object)urlSegmentValue);
                url.setQueryParameter(name, (Object)urlSegmentValue);
                urlSegmentsIterator.remove();
            }
            ++i;
        }
        if (!this.validateParameters(mountedParameters)) {
            return null;
        }
        if (urlSegments.size() == 0) {
            urlSegments.add(this.packageName);
            urlSegments.add(this.homePageName);
        } else {
            String lastSegment = (String)urlSegments.get(urlSegments.size() - 1);
            urlSegments.clear();
            urlSegments.add(this.packageName);
            if (this.isPackageClass(lastSegment)) {
                urlSegments.add(lastSegment);
            } else {
                urlSegments.add(this.homePageName);
            }
        }
        IRequestHandler mapRequest = this.mountedMapper.mapRequest(request.cloneWithUrl(url));
        if (mapRequest == null) {
            if (urlSegments.size() == 1) {
                urlSegments.add(this.homePageName);
            } else {
                urlSegments.set(1, this.homePageName);
            }
            mapRequest = this.mountedMapper.mapRequest(request.cloneWithUrl(url));
        }
        return mapRequest;
    }

    private boolean isPackageClass(String lastSegment) {
        String fqcn = this.packageName + '.' + lastSegment;
        Class<?> resolved = null;
        try {
            if (Application.exists()) {
                resolved = Application.get().getApplicationSettings().getClassResolver().resolveClass(fqcn);
            }
            if (resolved == null) {
                resolved = Class.forName(fqcn, false, Thread.currentThread().getContextClassLoader());
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getCompatibilityScore(Request request) {
        Url url = request.getUrl();
        int score = 0;
        List urlSegs = url.getSegments();
        int segmentsCount = urlSegs.size();
        if (segmentsCount == this.mountedSegments.length + 1) {
            ++score;
        }
        if (segmentsCount == this.mountedSegments.length) {
            ++score;
        }
        for (int i = 0; i < this.mountedSegments.length && i != segmentsCount; ++i) {
            String mountedSegment = this.mountedSegments[i];
            String urlSegment = (String)urlSegs.get(i);
            if (this.getPlaceholder(mountedSegment) != null || !mountedSegment.equals(urlSegment)) continue;
            score = 2 + score + score / 2;
        }
        return score;
    }
}

