/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.CoreLibrariesContributor;
import org.wicketstuff.openlayers.OpenLayersMap;

public class OpenLayersMapHeaderContributor
extends Behavior {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference WICKET_OMAP_JS = new JavaScriptResourceReference(OpenLayersMap.class, "wicket-openlayersmap.js");
    private final boolean developmentMode;
    private final String openLayersVersion;

    private static String getURL(boolean developmentMode, String version) {
        String prefix = "http://dev.openlayers.org/releases/OpenLayers-" + version;
        if (developmentMode) {
            return prefix + "/lib/OpenLayers.js";
        }
        return prefix + "/OpenLayers.js";
    }

    public OpenLayersMapHeaderContributor(boolean developmentMode, String openLayersVersion) {
        this.developmentMode = developmentMode;
        this.openLayersVersion = openLayersVersion;
    }

    public void renderHead(Component c, IHeaderResponse response) {
        String url = OpenLayersMapHeaderContributor.getURL(this.developmentMode, this.openLayersVersion);
        response.render((HeaderItem)JavaScriptHeaderItem.forUrl((String)url));
        CoreLibrariesContributor.contributeAjax((Application)c.getApplication(), (IHeaderResponse)response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)WICKET_OMAP_JS));
    }
}

