/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers.api;

import java.util.StringTokenizer;
import org.wicketstuff.openlayers.api.LonLat;
import org.wicketstuff.openlayers.api.Value;
import org.wicketstuff.openlayers.js.Constructor;

public class Bounds
implements Value {
    private static final long serialVersionUID = 1L;
    private final LonLat sw;
    private final LonLat ne;

    public Bounds(LonLat sw, LonLat ne) {
        this.sw = sw;
        this.ne = ne;
    }

    public LonLat getSW() {
        return this.sw;
    }

    public LonLat getNE() {
        return this.ne;
    }

    public String toString() {
        return this.getJSconstructor();
    }

    @Override
    public String getJSconstructor() {
        return new Constructor("OpenLayers.Bounds").add(this.sw.getLng()).add(this.sw.getLat()).add(this.ne.getLng()).add(this.ne.getLat()).toJS();
    }

    public int hashCode() {
        return this.sw.hashCode() ^ this.ne.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Bounds) {
            Bounds t = (Bounds)obj;
            return t.sw.equals(this.sw) && t.ne.equals(this.ne);
        }
        return false;
    }

    public static Bounds parse(String value) {
        StringTokenizer tokenizer;
        try {
            tokenizer = new StringTokenizer(value, "(, )");
        }
        catch (NullPointerException e) {
            return null;
        }
        if (tokenizer.countTokens() != 4) {
            return null;
        }
        LonLat sw = new LonLat(Float.valueOf(tokenizer.nextToken()).floatValue(), Float.valueOf(tokenizer.nextToken()).floatValue());
        LonLat ne = new LonLat(Float.valueOf(tokenizer.nextToken()).floatValue(), Float.valueOf(tokenizer.nextToken()).floatValue());
        return new Bounds(sw, ne);
    }

    public static Bounds parseWithNames(String value) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(value, "(, )");
            if (tokenizer.countTokens() != 6) {
                return null;
            }
            tokenizer.nextToken();
            LonLat sw = new LonLat(Float.valueOf(tokenizer.nextToken()).floatValue(), Float.valueOf(tokenizer.nextToken()).floatValue());
            tokenizer.nextToken();
            LonLat ne = new LonLat(Float.valueOf(tokenizer.nextToken()).floatValue(), Float.valueOf(tokenizer.nextToken()).floatValue());
            return new Bounds(sw, ne);
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

