/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers.api;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.wicketstuff.openlayers.OpenLayersMap;
import org.wicketstuff.openlayers.api.LonLat;
import org.wicketstuff.openlayers.api.Marker;
import org.wicketstuff.openlayers.api.PopupWindowPanel;

public class InfoWindow
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private LonLat latLng;
    private Marker marker;
    private PopupWindowPanel content = new PopupWindowPanel();

    public InfoWindow() {
        super("infoWindow");
        this.setOutputMarkupId(true);
        this.add(new Component[]{this.content});
    }

    public void update(AjaxRequestTarget target) {
        Request request = RequestCycle.get().getRequest();
        if (Boolean.parseBoolean(request.getRequestParameters().getParameterValue("hidden").toString())) {
            this.marker = null;
            this.latLng = null;
        }
    }

    public final String getJSinit() {
        if (this.latLng != null) {
            return this.getJSopen(this.latLng);
        }
        if (this.marker != null) {
            return this.getJSopen(this.marker);
        }
        return "";
    }

    public InfoWindow open(LonLat latLng) {
        this.latLng = latLng;
        this.marker = null;
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> {
            target.appendJavaScript((CharSequence)this.getJSopen(latLng));
            target.add(new Component[]{this});
        });
        return this;
    }

    public InfoWindow open(Marker marker) {
        this.latLng = null;
        this.marker = marker;
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> {
            target.appendJavaScript((CharSequence)this.getJSopen(marker));
            target.add(new Component[]{this});
        });
        return this;
    }

    public boolean isOpen() {
        return this.latLng != null || this.marker != null;
    }

    public void close() {
        this.marker = null;
        this.latLng = null;
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> {
            target.appendJavaScript((CharSequence)this.getJSclose());
            target.add(new Component[]{this});
        });
    }

    private String getJSopen(LonLat latLng) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("openInfoWindowTabs(");
        buffer.append(latLng.getJSconstructor());
        return this.getGMap2().getJSinvoke(buffer.toString());
    }

    private String getJSopen(Marker marker) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("openMarkerInfoWindowTabs('");
        buffer.append(marker.getId());
        return this.getGMap2().getJSinvoke(buffer.toString());
    }

    private String getJSclose() {
        return this.getGMap2().getJSinvoke("closeInfoWindow()");
    }

    private OpenLayersMap getGMap2() {
        return (OpenLayersMap)this.findParent(OpenLayersMap.class);
    }

    public WebMarkupContainer getContent() {
        return this.content;
    }

    public void setContent(PopupWindowPanel content) {
        this.content = content;
    }
}

