/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers.api;

import com.vividsolutions.jts.geom.Point;
import java.util.StringTokenizer;
import org.wicketstuff.openlayers.OpenLayersMapUtils;
import org.wicketstuff.openlayers.api.Value;
import org.wicketstuff.openlayers.js.Constructor;

public class LonLat
implements Value {
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT_PROJECTION = "EPSG:900913";
    private final Point point;
    private final String projection;
    private final String targetProjection;

    public LonLat(double lng, double lat) {
        this(OpenLayersMapUtils.createPoint(lng, lat));
    }

    public LonLat(double lng, double lat, String projection) {
        this(OpenLayersMapUtils.createPoint(lng, lat), projection, DEFAULT_PROJECTION);
    }

    public LonLat(double lng, double lat, String projection, String targetProjection) {
        this(OpenLayersMapUtils.createPoint(lng, lat), projection, targetProjection);
    }

    public LonLat(Point point) {
        this(point, DEFAULT_PROJECTION, DEFAULT_PROJECTION);
    }

    public LonLat(Point point, String projection) {
        this(point, projection, DEFAULT_PROJECTION);
    }

    public LonLat(Point point, String projection, String targetProjection) {
        this.point = point;
        this.projection = projection;
        this.targetProjection = targetProjection;
    }

    public double getLat() {
        return this.point.getY();
    }

    public double getLng() {
        return this.point.getX();
    }

    public String toString() {
        return this.getJSconstructor();
    }

    @Override
    public String getJSconstructor() {
        String jsLatLong = new Constructor("OpenLayers.LonLat").add(this.getLng()).add(this.getLat()).toJS();
        if (!this.projection.equals(this.targetProjection)) {
            jsLatLong = jsLatLong + ".transform(new OpenLayers.Projection(\"" + this.projection + "\")," + "new OpenLayers.Projection(\"" + this.targetProjection + "\"))";
        }
        return jsLatLong;
    }

    public int hashCode() {
        return new Double(this.getLat()).hashCode() ^ new Double(this.getLng()).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LonLat) {
            LonLat t = (LonLat)obj;
            return t.getLat() == this.getLat() && t.getLng() == this.getLng();
        }
        return false;
    }

    public Point getPoint() {
        return this.point;
    }

    public static LonLat parse(String value) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(value, "(, )");
            float lat = Float.valueOf(tokenizer.nextToken()).floatValue();
            float lng = Float.valueOf(tokenizer.nextToken()).floatValue();
            return new LonLat(lat, lng);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static LonLat parseWithNames(String value) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(value, "(, )");
            float lng = 0.0f;
            float lat = 0.0f;
            for (int i = 0; i < 2; ++i) {
                String item = tokenizer.nextToken().toLowerCase();
                if (item.startsWith("lon=")) {
                    lng = Float.parseFloat(item.substring(4));
                    continue;
                }
                if (item.startsWith("lat=")) {
                    lat = Float.parseFloat(item.substring(4));
                    continue;
                }
                return null;
            }
            return new LonLat(lng, lat);
        }
        catch (Exception e) {
            return null;
        }
    }
}

