/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers.api;

import java.util.ArrayList;
import java.util.Arrays;
import org.wicketstuff.openlayers.IOpenLayersMap;
import org.wicketstuff.openlayers.api.Icon;
import org.wicketstuff.openlayers.api.LonLat;
import org.wicketstuff.openlayers.api.Overlay;
import org.wicketstuff.openlayers.api.PopupWindowPanel;
import org.wicketstuff.openlayers.event.EventType;
import org.wicketstuff.openlayers.js.Constructor;

public class Marker
extends Overlay {
    private static final long serialVersionUID = 1L;
    private EventType[] events = new EventType[0];
    private Icon icon = null;
    private LonLat lonLat;
    private PopupWindowPanel popup = null;
    private IOpenLayersMap map = null;

    public Marker(LonLat gLatLng) {
        this(gLatLng, new EventType[0], null);
    }

    public Marker(LonLat gLatLng, IOpenLayersMap map) {
        this(gLatLng, new EventType[0], null);
        this.map = map;
    }

    public Marker(LonLat lonLat, EventType[] events, PopupWindowPanel popup) {
        this(lonLat, popup, events, null);
    }

    public Marker(LonLat lonLat, EventType[] events) {
        this(lonLat, events, null);
    }

    public Marker(LonLat gLatLng, PopupWindowPanel popup) {
        this(gLatLng, null, popup);
    }

    public Marker(LonLat lonLat, PopupWindowPanel popup, EventType[] events, Icon icon) {
        this.lonLat = lonLat;
        this.popup = popup;
        this.icon = icon;
        this.events = events;
    }

    public Marker(LonLat lonLat, PopupWindowPanel popup, Icon icon) {
        this(lonLat, popup, new EventType[0], icon);
    }

    public void addEvent(EventType evt) {
        if (this.events == null) {
            this.events = new EventType[0];
        }
        ArrayList<EventType> eventList = new ArrayList<EventType>(Arrays.asList(this.events));
        eventList.add(evt);
        this.events = new EventType[eventList.size()];
        eventList.toArray(this.events);
    }

    public EventType[] getEvents() {
        return this.events;
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    protected String getJSconstructor() {
        String transformation = "";
        if (this.map != null && this.map.getBusinessLogicProjection() != null) {
            transformation = ".transform(new OpenLayers.Projection(\"" + this.map.getBusinessLogicProjection() + "\"), " + this.map.getJSinvokeNoLineEnd("map") + ".getProjectionObject())";
        }
        Constructor constructor = new Constructor("OpenLayers.Marker").add(this.lonLat.getJSconstructor() + transformation);
        if (this.icon != null) {
            constructor.add(this.icon.getId());
        }
        return constructor.toJS();
    }

    public LonLat getLonLat() {
        return this.lonLat;
    }

    public PopupWindowPanel getPopup() {
        return this.popup;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setLagLng(LonLat gLatLng) {
        this.lonLat = gLatLng;
    }

    public void setMap(IOpenLayersMap map) {
        this.map = map;
    }

    public IOpenLayersMap getMap() {
        return this.map;
    }
}

