/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers.api.feature;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.wicketstuff.openlayers.IOpenLayersMap;
import org.wicketstuff.openlayers.api.feature.FeatureStyle;
import org.wicketstuff.openlayers.api.layer.Vector;

public abstract class Feature
implements Serializable {
    private static final long serialVersionUID = 364944041007700590L;
    private FeatureStyle featureStyle = null;
    private IOpenLayersMap map = null;
    private String displayInLayer = null;
    private List<Coordinate> coordinates = new ArrayList<Coordinate>();

    public Feature() {
        this(null, null);
    }

    public Feature(FeatureStyle featureStyle) {
        this(featureStyle, null);
    }

    public Feature(IOpenLayersMap map) {
        this(null, map);
    }

    public Feature(FeatureStyle featureStyle, IOpenLayersMap map) {
        this.featureStyle = featureStyle;
        this.map = map;
    }

    public String getId() {
        return String.valueOf(System.identityHashCode(this));
    }

    protected abstract String getType();

    public String getJSAddFeature(IOpenLayersMap map, Vector vector) {
        return this.getJSconstructor() + "var draw" + this.getId() + " = new OpenLayers.Feature.Vector(feature" + this.getId() + ", null, " + (this.featureStyle != null ? this.featureStyle.getJSGetStyleNoLineEnd(map) : "null") + ");\n" + map.getJSinvoke("addFeature(" + vector.getId() + ", draw" + this.getId() + ", " + this.getId() + ")");
    }

    public String getJSRemoveFeature(IOpenLayersMap map, Vector vector) {
        return map.getJSinvoke("removeFeature(" + vector.getId() + ", " + this.getId() + ")");
    }

    protected String getJScoordinateList(String type, String coordinateList) {
        return "var feature" + this.getId() + " = " + (type == null ? "" : "new " + type + "(") + (this.map != null && this.map.getBusinessLogicProjection() != null ? this.map.getJSinvokeNoLineEnd("") : "") + "convertArray([" + coordinateList + "]" + (this.map != null && this.map.getBusinessLogicProjection() != null ? ", \"" + this.map.getBusinessLogicProjection() + "\"" : "") + ")" + (type != null ? ")" : "") + ";\n";
    }

    public String getJSconstructor() {
        StringBuffer coordinateList = new StringBuffer();
        for (Coordinate coordinate : this.coordinates) {
            if (coordinateList.length() > 0) {
                coordinateList.append(", ");
            }
            coordinateList.append(coordinate.x + ", " + coordinate.y);
        }
        StringBuffer result = new StringBuffer();
        result.append("var feature" + this.getId() + " = ");
        if (this.getType() != null) {
            result.append("new " + this.getType() + "(");
        }
        if (this.map != null && this.map.getBusinessLogicProjection() != null) {
            result.append(this.map.getJSinvokeNoLineEnd(""));
        }
        result.append("convertArray([" + coordinateList.toString() + "]");
        if (this.map != null && this.map.getBusinessLogicProjection() != null) {
            result.append(", \"" + this.map.getBusinessLogicProjection() + "\"");
        }
        result.append(")");
        if (this.getType() != null) {
            result.append(")");
        }
        result.append(";\n");
        return result.toString();
    }

    public void setFeatureStyle(FeatureStyle featureStyle) {
        this.featureStyle = featureStyle;
    }

    public FeatureStyle getFeatureStyle() {
        return this.featureStyle;
    }

    public void setMap(IOpenLayersMap map) {
        this.map = map;
    }

    public IOpenLayersMap getMap() {
        return this.map;
    }

    public void setDisplayInLayer(String displayInLayer) {
        this.displayInLayer = displayInLayer;
    }

    public String getDisplayInLayer() {
        return this.displayInLayer;
    }

    public void setCoordinates(List<Coordinate> coordinates) {
        this.coordinates = coordinates;
    }

    public List<Coordinate> getCoordinates() {
        return this.coordinates;
    }
}

