/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers.api.layer;

import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.wicketstuff.openlayers.IOpenLayersMap;
import org.wicketstuff.openlayers.js.Constructor;
import org.wicketstuff.openlayers.js.ObjectLiteral;

public abstract class Layer {
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return String.valueOf(System.identityHashCode(this));
    }

    public final String getJSAddLayer(IOpenLayersMap map) {
        return "var layer" + this.getId() + " = " + this.getJSconstructor() + ";\n" + map.getJSinvoke("addLayer(layer" + this.getId() + ", " + this.getId() + ")");
    }

    public final void bindHeaderContributors(Component c) {
        c.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void renderHead(Component c, IHeaderResponse response) {
                Layer.this.bindHeaderContributors(response);
            }
        }});
    }

    protected abstract void bindHeaderContributors(IHeaderResponse var1);

    public abstract String getJSconstructor();

    protected String getJSOptionsMap(Map<String, String> options) {
        if (options == null || options.size() == 0) {
            return null;
        }
        ObjectLiteral builder = new ObjectLiteral();
        for (Map.Entry<String, String> entry : options.entrySet()) {
            builder.set(entry.getKey(), entry.getValue());
        }
        return builder.toJS();
    }

    protected String getJSconstructor(String javascriptTypeName, List<String> parameterList) {
        Constructor c = new Constructor(javascriptTypeName);
        for (String parameter : parameterList) {
            c.add(parameter);
        }
        return c.toJS();
    }
}

