/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers.event;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.wicketstuff.openlayers.OpenLayersMap;
import org.wicketstuff.openlayers.api.LonLat;
import org.wicketstuff.openlayers.api.Marker;
import org.wicketstuff.openlayers.api.Overlay;
import org.wicketstuff.openlayers.api.Size;
import org.wicketstuff.openlayers.event.EventType;

public abstract class PopupListener
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private boolean wantEvents;
    private OpenLayersMap openLayersMap;

    public OpenLayersMap getOpenLayersMap() {
        return this.openLayersMap;
    }

    public void setOpenLayersMap(OpenLayersMap openLayersMap) {
        this.openLayersMap = openLayersMap;
    }

    public PopupListener(boolean wantEvents) {
        this.wantEvents = wantEvents;
    }

    protected void onBind() {
        if (!(this.getComponent() instanceof OpenLayersMap)) {
            throw new IllegalArgumentException("must be bound to OpenlayersMap");
        }
    }

    protected final void respond(AjaxRequestTarget target) {
        this.onEvent(target);
    }

    protected final OpenLayersMap getOpenLayerMap() {
        return (OpenLayersMap)this.getComponent();
    }

    protected void onEvent(AjaxRequestTarget target) {
        Request request = RequestCycle.get().getRequest();
        Overlay overlay = null;
        String markerParameter = request.getRequestParameters().getParameterValue("marker").toString();
        if (markerParameter != null) {
            OpenLayersMap map = this.getOpenLayerMap();
            for (Overlay ovl : map.getOverlays()) {
                if (!ovl.getId().equals(markerParameter)) continue;
                overlay = ovl;
                break;
            }
        }
        String markerEvent = request.getRequestParameters().getParameterValue("event").toString();
        if (this.wantEvents) {
            EventType eventType = EventType.valueOf(markerEvent);
            this.onEvent(target, overlay, eventType);
        } else {
            this.onClick(target, overlay);
        }
    }

    public String getCallBackForMarker(Marker marker) {
        return this.getCallbackUrl() + "&marker=" + marker.getId();
    }

    public void clickAndOpenPopup(Marker marker, AjaxRequestTarget target) {
        String mapId = this.getOpenLayerMap().getJSInstance();
        String jsToRun = "if (" + mapId + ".popup != null) {" + "\t\t" + mapId + ".map.removePopup(" + mapId + ".popup);" + "\t\t" + mapId + ".popup.destroy();" + "\t\t" + mapId + ".popup = null;" + "}";
        target.prependJavaScript((CharSequence)jsToRun);
        this.getOpenLayerMap().getInfoWindow().getContent().replaceWith((Component)marker.getPopup());
        this.getOpenLayerMap().getInfoWindow().setContent(marker.getPopup());
        target.add(new Component[]{marker.getPopup()});
        jsToRun = mapId + ".popup = new OpenLayers.Popup('map', " + new LonLat(marker.getLonLat().getLng(), marker.getLonLat().getLat()) + ", " + new Size(195.0f, 250.0f).getJSconstructor() + ", document.getElementById(" + mapId + ".popupId).innerHTML, true);" + mapId + ".popup.setBackgroundColor('white');" + mapId + ".map.addPopup(" + mapId + ".popup);";
        target.appendJavaScript((CharSequence)jsToRun);
    }

    public void closePopup(AjaxRequestTarget target) {
        String mapId = this.getOpenLayerMap().getJSInstance();
        String jsToRun = "if (" + mapId + ".popup != null) {" + "\t\t" + mapId + ".map.removePopup(" + mapId + ".popup);" + "\t\t" + mapId + ".popup.destroy();" + "\t\t" + mapId + ".popup = null;" + "}";
        target.appendJavaScript((CharSequence)jsToRun);
    }

    protected void onClick(AjaxRequestTarget target, Overlay overlay) {
    }

    protected void onEvent(AjaxRequestTarget target, Overlay overlay, EventType event) {
    }
}

