/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.CoreLibrariesContributor;
import org.wicketstuff.openlayers.IOpenLayersMap;
import org.wicketstuff.openlayers.api.Bounds;
import org.wicketstuff.openlayers.api.IJavascriptComponent;
import org.wicketstuff.openlayers.api.LonLat;
import org.wicketstuff.openlayers.api.Marker;
import org.wicketstuff.openlayers.api.Overlay;
import org.wicketstuff.openlayers.api.feature.Feature;
import org.wicketstuff.openlayers.api.feature.FeatureStyle;
import org.wicketstuff.openlayers.api.layer.Layer;
import org.wicketstuff.openlayers.api.layer.Vector;
import org.wicketstuff.openlayers.event.EventType;
import org.wicketstuff.openlayers.event.OverlayListenerBehavior;

public class AjaxOpenLayersMap
extends WebMarkupContainer
implements IOpenLayersMap {
    private static final long serialVersionUID = 159201381315392564L;
    private List<Layer> layers;
    private final HashMap<String, String> options;
    private final List<Feature> features;
    private final List<IJavascriptComponent> controls = new ArrayList<IJavascriptComponent>();
    private final List<Overlay> overlays = new ArrayList<Overlay>();
    private final List<FeatureStyle> featureStyles;
    private final HashMap<String, Vector> featureVectors = new HashMap();
    private boolean externalControls = false;
    private Bounds bounds = null;
    private LonLat center = null;
    private Integer zoom = null;
    private String businessLogicProjection = null;
    private String markersLayerName = null;

    public AjaxOpenLayersMap(String id, List<Layer> layers) {
        this(id, layers, null);
    }

    public AjaxOpenLayersMap(String id, List<Layer> layers, HashMap<String, String> options) {
        this(id, layers, options, null);
    }

    public AjaxOpenLayersMap(String id, List<Layer> layers, HashMap<String, String> options, List<Feature> features) {
        this(id, layers, options, features, null);
    }

    public AjaxOpenLayersMap(String id, List<Layer> layers, HashMap<String, String> options, List<Feature> features, List<FeatureStyle> featureStyles) {
        super(id);
        this.setOutputMarkupId(true);
        this.layers = layers == null ? new ArrayList() : layers;
        this.options = options == null ? new HashMap() : options;
        this.features = features == null ? new ArrayList() : features;
        this.featureStyles = featureStyles == null ? new ArrayList() : featureStyles;
        this.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void renderHead(Component c, IHeaderResponse response) {
                response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)AjaxOpenLayersMap.this.getJSinit()));
            }
        }});
        for (Feature feature : this.features) {
            this.getFeatureVector(feature.getDisplayInLayer());
        }
    }

    public static void onPageRenderHead(IHeaderResponse response, String pathToOpenLayersJS) {
        if (pathToOpenLayersJS == null || pathToOpenLayersJS.trim().length() == 0) {
            pathToOpenLayersJS = "http://openlayers.org/api/";
        } else if (!(pathToOpenLayersJS = pathToOpenLayersJS.trim()).endsWith("/")) {
            pathToOpenLayersJS = pathToOpenLayersJS + "/";
        }
        pathToOpenLayersJS = pathToOpenLayersJS + "OpenLayers.js";
        response.render((HeaderItem)JavaScriptHeaderItem.forUrl((String)pathToOpenLayersJS));
        CoreLibrariesContributor.contributeAjax((Application)Application.get(), (IHeaderResponse)response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(AjaxOpenLayersMap.class, "wicket-openlayersmap.js")));
    }

    @Override
    public void setExternalControls(boolean externalControls) {
        this.externalControls = externalControls;
    }

    @Override
    public boolean isExternalControls() {
        return this.externalControls;
    }

    @Override
    public void setBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public void setCenter(LonLat center) {
        this.center = center;
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> target.appendJavaScript((CharSequence)this.getJSSetCenter()));
    }

    @Override
    public LonLat getCenter() {
        return this.center;
    }

    @Override
    public void setZoom(Integer zoom) {
        this.zoom = zoom;
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> target.appendJavaScript((CharSequence)this.getJSSetCenter()));
    }

    @Override
    public Integer getZoom() {
        return this.zoom;
    }

    @Override
    public void setCenter(LonLat center, Integer zoom) {
        this.center = center;
        this.zoom = zoom;
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> target.appendJavaScript((CharSequence)this.getJSSetCenter()));
    }

    private String getJSSetCenter() {
        if (this.center == null) {
            return "";
        }
        String transformation = "";
        if (this.getBusinessLogicProjection() != null) {
            transformation = ".transform(new OpenLayers.Projection(\"" + this.getBusinessLogicProjection() + "\"), " + this.getJSinvokeNoLineEnd("map") + ".getProjectionObject())";
        }
        if (this.zoom == null) {
            return this.getJSinvoke("setCenter(" + this.center.getJSconstructor() + transformation + ")");
        }
        return this.getJSinvoke("setCenter(" + this.center.getJSconstructor() + transformation + ", " + this.zoom.toString() + ")");
    }

    private String getJSSetBusinessLogicProjection() {
        if (this.businessLogicProjection == null) {
            return this.getJSinvoke("setBusinessLogicProjection(null)");
        }
        return this.getJSinvoke("setBusinessLogicProjection('" + this.businessLogicProjection + "')");
    }

    @Override
    public IOpenLayersMap addControl(IJavascriptComponent control) {
        this.controls.add(control);
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> target.appendJavaScript((CharSequence)control.getJSadd(this)));
        return this;
    }

    @Override
    public IOpenLayersMap addOverlay(Overlay overlay) {
        this.overlays.add(overlay);
        if (overlay instanceof Marker) {
            ((Marker)overlay).setMap(this);
        }
        for (OverlayListenerBehavior behavior : overlay.getBehaviors()) {
            this.add(new Behavior[]{behavior});
        }
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> target.appendJavaScript((CharSequence)this.getJsOverlay(overlay)));
        return this;
    }

    public IOpenLayersMap addLayer(Layer layer) {
        this.layers.add(layer);
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> target.appendJavaScript((CharSequence)layer.getJSAddLayer(this)));
        return this;
    }

    public IOpenLayersMap addFeature(Feature feature) {
        this.features.add(feature);
        feature.setMap(this);
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> target.appendJavaScript((CharSequence)feature.getJSAddFeature(this, this.getFeatureVector(feature.getDisplayInLayer()))));
        return this;
    }

    public IOpenLayersMap addFeatureStyle(FeatureStyle featureStyle) {
        this.featureStyles.add(featureStyle);
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> target.appendJavaScript((CharSequence)featureStyle.getJSAddStyle(this)));
        return this;
    }

    public IOpenLayersMap removeFeatureStyle(FeatureStyle featureStyle) {
        while (this.featureStyles.contains(featureStyle)) {
            this.featureStyles.remove(featureStyle);
        }
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> target.appendJavaScript((CharSequence)featureStyle.getJSRemoveStyle(this)));
        return this;
    }

    @Override
    public IOpenLayersMap clearOverlays() {
        for (Overlay overlay : this.overlays) {
            for (OverlayListenerBehavior behavior : overlay.getBehaviors()) {
                this.remove(new Behavior[]{behavior});
            }
        }
        this.overlays.clear();
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> target.appendJavaScript((CharSequence)this.getJSinvoke("clearOverlays()")));
        return this;
    }

    protected String getJSinit() {
        String jsMarkersLayerName;
        StringBuffer js = new StringBuffer();
        String string = jsMarkersLayerName = this.getMarkersLayerName() == null ? ", null" : ", '" + this.getMarkersLayerName() + "'";
        if (this.options.size() > 0) {
            js.append("\nvar options = {");
            boolean first = true;
            for (String key : this.options.keySet()) {
                if (first) {
                    first = false;
                } else {
                    js.append(",\n");
                }
                js.append(key + ":" + this.options.get(key));
            }
            js.append("};\n");
            js.append("new WicketOMap('" + this.getMarkupId() + "', options" + jsMarkersLayerName + ", true);\n");
        } else {
            js.append("new WicketOMap('" + this.getMarkupId() + "', null" + jsMarkersLayerName + ", true);\n");
        }
        for (FeatureStyle featureStyle : this.featureStyles) {
            js.append(featureStyle.getJSAddStyle(this));
        }
        for (Feature feature : this.features) {
            this.getFeatureVector(feature.getDisplayInLayer());
        }
        for (Layer layer : this.getLayers()) {
            js.append(layer.getJSAddLayer(this));
        }
        for (Feature feature : this.features) {
            js.append(feature.getJSAddFeature(this, this.getFeatureVector(feature.getDisplayInLayer())));
        }
        js.append(this.getJSSetCenter());
        if (this.center == null || this.zoom == null) {
            js.append(this.getJSinvoke("zoomToMaxExtent()"));
        }
        for (IJavascriptComponent control : this.controls) {
            js.append(control.getJSadd(this));
        }
        for (Overlay overlay : this.overlays) {
            js.append(this.getJsOverlay(overlay));
        }
        if (this.businessLogicProjection != null) {
            js.append(this.getJSSetBusinessLogicProjection());
        }
        return js.toString();
    }

    @Override
    public String getJSinvoke(String invocation) {
        return "Wicket.omaps['" + this.getMarkupId() + "']." + invocation + ";\n";
    }

    @Override
    public String getJSinvokeNoLineEnd(String invocation) {
        return "Wicket.omaps['" + this.getMarkupId() + "']." + invocation;
    }

    private String getJsOverlay(Overlay overlay) {
        String jsToRun = overlay.getJSadd(this) + "\n";
        if (overlay instanceof Marker) {
            Marker marker = (Marker)overlay;
            if (marker.getPopup() != null && (marker.getEvents() == null || marker.getEvents().length == 0)) {
                marker.addEvent(EventType.mousedown);
            }
            if (marker.getIcon() != null) {
                jsToRun = marker.getIcon().getSize().getJSadd() + marker.getIcon().getOffset().getJSadd() + marker.getIcon().getJSadd() + jsToRun;
            }
        }
        return jsToRun;
    }

    @Override
    public IOpenLayersMap removeControl(IJavascriptComponent control) {
        this.controls.remove(control);
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> target.appendJavaScript((CharSequence)control.getJSremove(this)));
        return this;
    }

    @Override
    public IOpenLayersMap removeOverlay(Overlay overlay) {
        while (this.overlays.contains(overlay)) {
            this.overlays.remove(overlay);
        }
        for (OverlayListenerBehavior behavior : overlay.getBehaviors()) {
            this.remove(new Behavior[]{behavior});
        }
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> target.appendJavaScript((CharSequence)overlay.getJSremove(this)));
        return this;
    }

    public IOpenLayersMap removeFeature(Feature feature) {
        while (this.features.contains(feature)) {
            this.features.remove(feature);
        }
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> target.appendJavaScript((CharSequence)feature.getJSRemoveFeature(this, this.getFeatureVector(feature.getDisplayInLayer()))));
        return this;
    }

    @Override
    public void update(AjaxRequestTarget target) {
        Request request = RequestCycle.get().getRequest();
        this.center = LonLat.parseWithNames(request.getRequestParameters().getParameterValue("centerConverted").toString());
        this.zoom = Integer.parseInt(request.getRequestParameters().getParameterValue("zoomConverted").toString());
        this.bounds = Bounds.parseWithNames(request.getRequestParameters().getParameterValue("boundsConverted").toString());
    }

    @Override
    public List<Layer> getLayers() {
        return this.layers;
    }

    @Override
    public List<IJavascriptComponent> getControls() {
        return this.controls;
    }

    @Override
    public String getJSInstance() {
        return "Wicket.omaps['" + this.getMarkupId() + "']";
    }

    @Override
    public List<Overlay> getOverlays() {
        return Collections.unmodifiableList(this.overlays);
    }

    @Override
    public void setLayers(List<Layer> layers) {
        this.layers = layers;
    }

    @Override
    public void setOverlays(List<Overlay> overlays) {
        this.clearOverlays();
        for (Overlay overlay : overlays) {
            this.addOverlay(overlay);
        }
    }

    @Override
    public void setBusinessLogicProjection(String businessLogicProjection) {
        this.businessLogicProjection = businessLogicProjection;
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> target.appendJavaScript((CharSequence)this.getJSSetBusinessLogicProjection()));
    }

    @Override
    public String getBusinessLogicProjection() {
        return this.businessLogicProjection;
    }

    public Vector getFeatureVector(String name) {
        Vector vector = this.featureVectors.get(name);
        if (vector == null) {
            vector = new Vector(name == null ? "Default" : name);
            this.addLayer(vector);
            this.featureVectors.put(name, vector);
        }
        return vector;
    }

    public void setMarkersLayerName(String markersLayerName) {
        this.markersLayerName = markersLayerName;
    }

    public String getMarkersLayerName() {
        return this.markersLayerName;
    }

    public void setVisibleOnlyLayers(String ... names) {
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> {
            ArrayList<String> invisibleNames = new ArrayList<String>();
            invisibleNames.add(this.markersLayerName);
            invisibleNames.addAll(this.featureVectors.keySet());
            StringBuffer visibleLayers = new StringBuffer();
            String layerId = null;
            for (String name : names) {
                layerId = this.findLayerId(name);
                if (layerId != null) {
                    if (visibleLayers.length() > 0) {
                        visibleLayers.append(",");
                    }
                    visibleLayers.append(layerId);
                }
                invisibleNames.remove(name);
            }
            StringBuffer invisibleLayers = new StringBuffer();
            for (String name : invisibleNames) {
                layerId = this.findLayerId(name);
                if (layerId == null) continue;
                if (invisibleLayers.length() > 0) {
                    invisibleLayers.append(",");
                }
                invisibleLayers.append(layerId);
            }
            target.appendJavaScript((CharSequence)this.getJSinvoke("setLayersVisibility([" + visibleLayers.toString() + "], [" + invisibleLayers.toString() + "])"));
        });
    }

    public void toggleLayer(String name) {
        String layerId = this.findLayerId(name);
        if (layerId != null) {
            this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> target.appendJavaScript((CharSequence)this.getJSinvoke("toggleLayer(" + layerId + ")")));
        }
    }

    private String findLayerId(String name) {
        Vector vector = this.featureVectors.get(name);
        if (vector != null) {
            return vector.getId();
        }
        return this.markersLayerName != null && this.markersLayerName.equals(name) ? "1" : null;
    }
}

