/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wicketstuff.openlayers.AjaxOpenLayersMap;
import org.wicketstuff.openlayers.api.IMapCenter;
import org.wicketstuff.openlayers.api.LonLat;
import org.wicketstuff.openlayers.api.Marker;
import org.wicketstuff.openlayers.api.feature.Feature;
import org.wicketstuff.openlayers.api.feature.FeatureStyle;
import org.wicketstuff.openlayers.api.layer.Layer;

public class MapLayer
implements Serializable {
    private static final long serialVersionUID = 3495178737214944354L;
    private final IMapCenter init_location;
    private AjaxOpenLayersMap map = null;
    private LonLat center = null;
    private Integer zoom = null;
    private String businessLogicProjection = null;
    private String markersLayerName = null;
    private final Map<String, Marker> markerList = new HashMap<String, Marker>();
    private final Map<String, Feature2FeatureStyle> featureList = new HashMap<String, Feature2FeatureStyle>();
    private final Map<String, FeatureStyle> featureStyleList = new HashMap<String, FeatureStyle>();

    public MapLayer(IMapCenter init_location, Object ... values) {
        this.init_location = init_location;
        this.init(values);
    }

    protected void init(Object ... values) {
    }

    public void addMarker(String uniqKey, Marker marker) {
        if (this.markerList.containsKey(uniqKey)) {
            this.removeMarker(uniqKey);
        }
        this.markerList.put(uniqKey, marker);
        if (this.map != null) {
            this.map.addOverlay(marker);
        }
    }

    public Marker getMarker(String uniqKey) {
        return this.markerList.get(uniqKey);
    }

    public void removeMarker(String uniqKey) {
        Marker remove = this.markerList.remove(uniqKey);
        if (remove != null && this.map != null) {
            this.map.removeOverlay(remove);
        }
    }

    public void addFeature(String uniqKey, Feature feature) {
        this.addFeature(uniqKey, feature, null);
    }

    public void addFeature(String uniqKey, Feature feature, String baseFeatureUniqKey, String color) {
        FeatureStyle featureStyle;
        FeatureStyle baseFeatureStyle = this.featureStyleList.get(baseFeatureUniqKey);
        FeatureStyle featureStyle2 = featureStyle = baseFeatureStyle == null || color == null ? null : new FeatureStyle(baseFeatureStyle);
        if (featureStyle != null) {
            featureStyle.setFillColor(color);
            featureStyle.setStrokeColor(color);
        }
        this.addFeature(baseFeatureUniqKey, feature, featureStyle);
    }

    public void addFeature(String uniqKey, Feature feature, FeatureStyle featureStyle) {
        if (this.featureList.containsKey(uniqKey)) {
            this.removeFeature(uniqKey);
        }
        if (featureStyle != null) {
            feature.setFeatureStyle(featureStyle);
        }
        this.featureList.put(uniqKey, new Feature2FeatureStyle(feature, featureStyle));
        if (this.map != null) {
            if (featureStyle != null) {
                this.map.addFeatureStyle(featureStyle);
            }
            this.map.addFeature(feature);
        }
    }

    public Feature getFeature(String uniqKey) {
        Feature2FeatureStyle result = this.featureList.get(uniqKey);
        return result == null ? null : result.getFeature();
    }

    public void removeFeature(String uniqKey) {
        Feature2FeatureStyle remove = this.featureList.remove(uniqKey);
        if (remove != null && this.map != null) {
            this.map.removeFeature(remove.getFeature());
            if (remove.getFeatureStyle() != null) {
                this.map.removeFeatureStyle(remove.getFeatureStyle());
            }
        }
    }

    public void addFeatureStyle(String uniqKey, FeatureStyle featureStyle) {
        if (this.featureStyleList.containsKey(uniqKey)) {
            this.removeFeatureStyle(uniqKey);
        }
        this.featureStyleList.put(uniqKey, featureStyle);
        if (this.map != null) {
            this.map.addFeatureStyle(featureStyle);
        }
    }

    public FeatureStyle getFeatureStyle(String uniqKey) {
        return this.featureStyleList.get(uniqKey);
    }

    public void removeFeatureStyle(String uniqKey) {
        FeatureStyle remove = this.featureStyleList.remove(uniqKey);
        if (remove != null && this.map != null) {
            this.map.removeFeatureStyle(remove);
        }
    }

    public void setCenter(IMapCenter mapCenter) {
        this.setCenter(mapCenter.getLongitude(), mapCenter.getLatitude());
        this.setZoom(mapCenter.getZoom());
    }

    public void setCenter(Double longitude, Double latitude) {
        if (longitude != null && latitude != null) {
            this.setCenter(new LonLat(longitude, latitude));
        }
    }

    public void setCenter(LonLat center) {
        this.center = center;
        if (this.map != null) {
            this.map.setCenter(center);
        }
    }

    public LonLat getCenter() {
        if (this.map != null) {
            this.center = this.map.getCenter();
        }
        return this.center;
    }

    public void setZoom(Integer zoom) {
        this.zoom = zoom;
        if (this.map != null) {
            this.map.setZoom(zoom);
        }
    }

    public Integer getZoom() {
        if (this.map != null) {
            this.zoom = this.map.getZoom();
        }
        return this.zoom;
    }

    public void setBusinessLogicProjection(String businessLogicProjection) {
        this.businessLogicProjection = businessLogicProjection;
        if (this.map != null) {
            this.map.setBusinessLogicProjection(businessLogicProjection);
        }
    }

    public String getBusinessLogicProjection() {
        if (this.map != null) {
            this.businessLogicProjection = this.map.getBusinessLogicProjection();
        }
        return this.businessLogicProjection;
    }

    public void setMarkersLayerName(String markersLayerName) {
        this.markersLayerName = markersLayerName;
        if (this.map != null) {
            this.map.setMarkersLayerName(markersLayerName);
        }
    }

    public String getMarkersLayerName() {
        if (this.map != null) {
            this.markersLayerName = this.map.getMarkersLayerName();
        }
        return this.markersLayerName;
    }

    public void updateInitLocation() {
        if (this.init_location != null) {
            this.init_location.setLongitude(this.center == null ? null : Double.valueOf(this.center.getLng()));
            this.init_location.setLatitude(this.center == null ? null : Double.valueOf(this.center.getLat()));
            this.init_location.setZoom(this.zoom == null ? null : Integer.valueOf(this.zoom));
        }
    }

    public AjaxOpenLayersMap getMapPanel(String id, List<Layer> layers, HashMap<String, String> options) {
        if (this.map == null) {
            if (this.init_location != null) {
                if (this.center == null) {
                    this.setCenter(this.init_location.getLongitude(), this.init_location.getLatitude());
                }
                if (this.zoom == null && this.init_location.getZoom() != null) {
                    this.zoom = (int)this.init_location.getZoom();
                }
            }
            this.map = new AjaxOpenLayersMap(id, layers, options);
            if (this.businessLogicProjection != null) {
                this.map.setBusinessLogicProjection(this.businessLogicProjection);
            }
            if (this.center != null && this.zoom != null) {
                this.map.setCenter(this.center, this.zoom);
            }
            if (this.markersLayerName != null) {
                this.map.setMarkersLayerName(this.markersLayerName);
            }
            for (Marker marker : this.markerList.values()) {
                this.map.addOverlay(marker);
            }
            for (FeatureStyle featureStyle : this.featureStyleList.values()) {
                this.map.addFeatureStyle(featureStyle);
            }
            for (Feature2FeatureStyle feature2FeatureStyle : this.featureList.values()) {
                if (feature2FeatureStyle.getFeatureStyle() != null) {
                    this.map.addFeatureStyle(feature2FeatureStyle.getFeatureStyle());
                }
                this.map.addFeature(feature2FeatureStyle.getFeature());
            }
        }
        return this.map;
    }

    public AjaxOpenLayersMap getMapPanel() {
        return this.map;
    }

    public void reset() {
        this.map = null;
        this.markerList.clear();
        this.featureList.clear();
        this.featureStyleList.clear();
        this.center = null;
        this.zoom = null;
        this.businessLogicProjection = null;
        this.markersLayerName = null;
    }

    public void cleanMapPanel(Object ... values) {
        while (!this.featureList.isEmpty()) {
            this.removeFeature(this.featureList.keySet().iterator().next());
        }
        while (!this.featureStyleList.isEmpty()) {
            this.removeFeatureStyle(this.featureStyleList.keySet().iterator().next());
        }
        while (!this.markerList.isEmpty()) {
            this.removeMarker(this.markerList.keySet().iterator().next());
        }
        if (this.init_location != null) {
            this.setCenter(this.init_location);
        }
        this.init(values);
    }

    public final Set<String> getMarkerIdList() {
        return this.markerList.keySet();
    }

    public final Set<String> getFeatureIdList() {
        return this.featureList.keySet();
    }

    public final Set<String> getFeatureStyleIdList() {
        return this.featureStyleList.keySet();
    }

    private static class Feature2FeatureStyle
    implements Serializable {
        private static final long serialVersionUID = 3495178735014944354L;
        private final Feature feature;
        private final FeatureStyle featureStyle;

        public Feature2FeatureStyle(Feature feature, FeatureStyle featureStyle) {
            this.feature = feature;
            this.featureStyle = featureStyle;
        }

        public Feature getFeature() {
            return this.feature;
        }

        public FeatureStyle getFeatureStyle() {
            return this.featureStyle;
        }
    }
}

