/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.wicketstuff.openlayers.IOpenLayersMap;
import org.wicketstuff.openlayers.api.IJavascriptComponent;
import org.wicketstuff.openlayers.event.OverlayListenerBehavior;

public abstract class Overlay
implements IJavascriptComponent {
    private static final long serialVersionUID = 1L;
    List<OverlayListenerBehavior> behaviors = new ArrayList<OverlayListenerBehavior>();

    public Overlay addBehavior(OverlayListenerBehavior behavior) {
        behavior.setGOverlay(this);
        this.behaviors.add(behavior);
        return this;
    }

    public Overlay removeBehavior(OverlayListenerBehavior behavior) {
        while (this.behaviors.contains((Object)behavior)) {
            this.behaviors.remove((Object)behavior);
        }
        behavior.setGOverlay(null);
        return this;
    }

    public Overlay clearBehaviors() {
        this.behaviors.clear();
        return this;
    }

    public List<OverlayListenerBehavior> getBehaviors() {
        return Collections.unmodifiableList(this.behaviors);
    }

    public String getOverlayJSVar() {
        return "overlay" + this.getId();
    }

    @Override
    public String getJSadd(IOpenLayersMap map) {
        StringBuffer js = new StringBuffer();
        js.append("var " + this.getOverlayJSVar() + " = " + this.getJSconstructor() + ";\n");
        js.append(map.getJSinvoke("addOverlay('" + this.getId() + "', overlay" + this.getId() + ")"));
        return js.toString();
    }

    @Override
    public String getJSremove(IOpenLayersMap map) {
        return map.getJSinvoke("removeOverlay('" + this.getId() + "')");
    }

    @Override
    public JavaScriptResourceReference[] getJSResourceReferences() {
        return null;
    }

    @Override
    public String getId() {
        return String.valueOf(System.identityHashCode(this));
    }

    protected abstract String getJSconstructor();
}

