/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers.api.control;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.wicketstuff.openlayers.IOpenLayersMap;
import org.wicketstuff.openlayers.api.IJavascriptComponent;
import org.wicketstuff.openlayers.api.layer.Layer;

public class AbstractControl
implements IJavascriptComponent {
    private static final long serialVersionUID = -9139375207645853318L;
    private final boolean externalizable;
    private final String name;
    private List<Layer> layerList = null;
    private LinkedList<IModel<String>> eventJavascript = new LinkedList();

    protected AbstractControl(String name, boolean externalizable) {
        this.name = name;
        this.externalizable = externalizable;
    }

    protected String getJSadd(IOpenLayersMap map, Map<String, String> parameters) {
        return this.getJSadd(map, "OpenLayers.Control." + this.name, parameters);
    }

    protected String getJSadd(IOpenLayersMap map, String javascriptClassName, Map<String, String> parameters) {
        if (map.isExternalControls() && this.externalizable) {
            parameters.put("div", "OpenLayers.Util.getElement('wicketOpenlayer" + this.name + "')");
        }
        StringBuffer buf = new StringBuffer();
        LinkedList<String> keyList = new LinkedList<String>();
        keyList.addAll(parameters.keySet());
        if (keyList.size() > 0) {
            int last = keyList.size() - 1;
            for (int i = 0; i < last; ++i) {
                String key = (String)keyList.get(i);
                String value = parameters.get(key);
                buf.append(key);
                buf.append(": ");
                buf.append(value);
                buf.append(", ");
            }
            String key = (String)keyList.get(last);
            String value = parameters.get(key);
            buf.append(key);
            buf.append(": ");
            buf.append(value);
        }
        return this.getJSadd(map, javascriptClassName, buf.toString());
    }

    protected String getJSadd(IOpenLayersMap map, String parameterString) {
        return this.getJSadd(map, "OpenLayers.Control." + this.name, parameterString);
    }

    protected String getJSadd(IOpenLayersMap map, String javascriptClassName, String parameterString) {
        String invocation = null;
        String id = this.getId();
        StringBuffer layers = new StringBuffer();
        if (this.layerList != null && !this.layerList.isEmpty()) {
            layers.append("[");
            for (Layer item : this.layerList) {
                if (layers.length() > 1) {
                    layers.append(", ");
                }
                layers.append("layer" + item.getId());
            }
            layers.append("]");
        }
        invocation = parameterString.length() == 0 ? map.getJSinvoke("addControl('" + id + "', new " + javascriptClassName + "(" + layers.toString() + "))") : map.getJSinvoke("addControl('" + id + "', new " + javascriptClassName + "(" + (layers.length() > 0 ? layers.toString() + ", " : "") + "{" + parameterString + "}))");
        if (this.eventJavascript.size() > 0) {
            StringBuffer renderedJavascript = new StringBuffer(invocation);
            for (IModel iModel : this.eventJavascript) {
                renderedJavascript.append((String)iModel.getObject());
            }
            return renderedJavascript.toString();
        }
        return invocation;
    }

    @Override
    public String getJSadd(IOpenLayersMap map) {
        return this.getJSadd(map, "");
    }

    @Override
    public String getJSremove(IOpenLayersMap map) {
        return map.getJSinvoke("removeControl('" + this.name + "')");
    }

    @Override
    public String getId() {
        return this.name + String.valueOf(System.identityHashCode(this));
    }

    public void registerJavascriptEvent(final IOpenLayersMap map, final String event, final IModel<String> eventHandlingJavascriptModel) {
        this.eventJavascript.add((IModel<String>)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                StringBuffer buf = new StringBuffer();
                buf.append(map.getJSinvokeNoLineEnd("controls['" + AbstractControl.this.getId() + "'].events.register(\""));
                buf.append(event);
                buf.append("\", this, function (evt) {");
                buf.append((String)eventHandlingJavascriptModel.getObject());
                buf.append("});\n");
                return buf.toString();
            }
        });
    }

    @Override
    public JavaScriptResourceReference[] getJSResourceReferences() {
        return null;
    }

    protected String getJSinvoke(IOpenLayersMap map, String invocation) {
        return map.getJSinvoke("controls['" + this.getId() + "']." + invocation);
    }

    public void setLayerList(List<Layer> layerList) {
        this.layerList = layerList;
    }

    public List<Layer> getLayerList() {
        return this.layerList;
    }
}

