/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers.api.layer;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.wicketstuff.openlayers.api.layer.Layer;
import org.wicketstuff.openlayers.js.JSUtils;

public class OSM
extends Layer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private OSMLayer layer;

    public OSM(String name, OSMLayer layer) {
        this.setName(name);
        this.layer = layer;
    }

    @Override
    protected void bindHeaderContributors(IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forUrl((String)"http://www.openstreetmap.org/openlayers/OpenStreetMap.js"));
    }

    @Override
    public String getJSconstructor() {
        String quotedName = JSUtils.getQuotedString(this.getName());
        switch (this.layer) {
            case Mapnik: {
                return this.getJSconstructor("OpenLayers.Layer.OSM.Mapnik", Arrays.asList(quotedName));
            }
            case TilesAtHome: {
                return this.getJSconstructor("OpenLayers.Layer.OSM.Osmarender", Arrays.asList(quotedName));
            }
            case CycleMap: {
                return this.getJSconstructor("OpenLayers.Layer.OSM.CycleMap", Arrays.asList(quotedName));
            }
        }
        return this.getJSconstructor("OpenLayers.Layer.OSM.Mapnik", Arrays.asList(quotedName));
    }

    public static enum OSMLayer {
        Mapnik,
        TilesAtHome,
        CycleMap;

    }
}

