/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers.event;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.wicketstuff.openlayers.IOpenLayersMap;
import org.wicketstuff.openlayers.OpenLayersMapUtils;

public abstract class DrawListenerBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;

    public void renderHead(Component c, IHeaderResponse response) {
        super.renderHead(c, response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.getJSaddListener()));
    }

    protected void onBind() {
        if (!(this.getComponent() instanceof IOpenLayersMap)) {
            throw new IllegalArgumentException("must be bound to Openlayers map");
        }
    }

    public String getJSaddListener() {
        return this.getOpenLayersMap().getJSinvoke("addDrawFeature('" + this.getCallbackUrl() + "')");
    }

    protected final IOpenLayersMap getOpenLayersMap() {
        return (IOpenLayersMap)this.getComponent();
    }

    protected final void respond(AjaxRequestTarget target) {
        this.onEvent(target);
    }

    protected void onEvent(AjaxRequestTarget target) throws RuntimeException {
        Request request = RequestCycle.get().getRequest();
        String wkt = request.getRequestParameters().getParameterValue("wkt").toString();
        WKTReader wktReader = new WKTReader(OpenLayersMapUtils.getGeoFactory());
        Geometry geom = null;
        try {
            geom = wktReader.read(wkt);
        }
        catch (ParseException e) {
            throw new RuntimeException("Could not parse wkt", e);
        }
        this.onDrawEnded(geom, target);
    }

    protected abstract void onDrawEnded(Geometry var1, AjaxRequestTarget var2);
}

