/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.overlay;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.openlayers3.api.coordinate.LongLat;
import org.wicketstuff.openlayers3.api.overlay.Overlay;

public class Popover
extends Overlay {
    private String placement;
    private boolean html = true;
    private IModel<String> titleModel;
    private IModel<String> model;

    public Popover(Component component, IModel<String> titleModel, IModel<String> model) {
        super(component);
        this.titleModel = titleModel;
        this.model = model;
    }

    public String getPlacement() {
        return this.placement;
    }

    public void setPlacement(String placement) {
        this.placement = placement;
    }

    public Popover placement(String placement) {
        this.setPlacement(placement);
        return this;
    }

    public boolean getHtml() {
        return this.html;
    }

    public void setHtml(boolean html) {
        this.html = html;
    }

    public Popover html(boolean html) {
        this.setHtml(html);
        return this;
    }

    public IModel<String> getModel() {
        return this.model;
    }

    public void setModel(IModel<String> model) {
        this.model = model;
    }

    public Popover model(IModel<String> model) {
        this.setModel(model);
        return this;
    }

    public Popover position(LongLat position) {
        this.setPosition(position);
        return this;
    }

    public Popover positioning(Overlay.Positioning positioning) {
        this.setPositioning(positioning);
        return this;
    }

    public Popover element(Component element) {
        this.setElement(element);
        return this;
    }

    public Popover stopEvent(Boolean stopEvent) {
        this.setStopEvent(stopEvent);
        return this;
    }

    public Popover show(AjaxRequestTarget target) {
        this.hide(target);
        target.appendJavaScript((CharSequence)this.renderPopoverJs());
        return this;
    }

    public Popover hide(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)("$(" + this.getJsId() + ".getElement()).popover('destroy');"));
        return this;
    }

    public String getJsId() {
        return "popup_" + this.element.getMarkupId();
    }

    private String renderPopoverJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("var popup = " + this.getJsId() + ";");
        builder.append("var element = popup.getElement();");
        builder.append("popup.setPosition(" + this.position.renderJs() + ");");
        builder.append("$(element).popover({");
        builder.append("'trigger': 'manual', 'animation': false,");
        if (this.titleModel != null) {
            builder.append("'title': '" + this.escapeQuoteJs((String)this.titleModel.getObject()) + "',");
        }
        if (this.placement != null) {
            builder.append("'placement': '" + this.placement + "',");
        }
        builder.append("'html': '" + this.html + "',");
        if (this.html) {
            builder.append("'content': '" + this.escapeQuoteJs((String)this.model.getObject()) + "',");
        } else {
            builder.append("'content': '" + Strings.escapeMarkup((CharSequence)((CharSequence)this.model.getObject())) + "',");
        }
        builder.append("});");
        if (this.titleModel != null) {
            builder.append("$(element).data('original-title', '");
            builder.append(this.escapeQuoteJs((String)this.titleModel.getObject()));
            builder.append("');");
        } else {
            builder.append("$(element).data('original-title', '');");
        }
        if (this.html) {
            builder.append("$(element).attr('data-content', '" + this.escapeQuoteJs((String)this.model.getObject()) + "');");
        } else {
            builder.append("$(element).attr('data-content', '" + Strings.escapeMarkup((CharSequence)((CharSequence)this.model.getObject())) + "');");
        }
        builder.append("$(element).popover('show');");
        return builder.toString();
    }
}

