/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.component;

import java.io.Serializable;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.openlayers3.api.coordinate.LongLat;
import org.wicketstuff.openlayers3.api.overlay.Overlay;
import org.wicketstuff.openlayers3.api.util.Color;
import org.wicketstuff.openlayers3.component.Marker;
import org.wicketstuff.openlayers3.component.PopoverPanel;

public class MarkerPopover
extends Marker {
    public static final String DEFAULT_PLACEMENT = "right";
    public static final Overlay.Positioning DEFAULT_POSITIONING = Overlay.Positioning.TopCenter;
    private PopoverPanel popoverPanel;
    private IModel<String> titleModel;
    private IModel<String> contentModel;
    private IModel<LongLat> positionModel;
    private IModel<String> placementModel;

    public MarkerPopover(String id, IModel<Color> colorModel, PopoverPanel popoverPanel, IModel<String> titleModel, IModel<String> contentModel, IModel<LongLat> positionModel) {
        this(id, colorModel, popoverPanel, titleModel, contentModel, positionModel, (IModel<String>)Model.of((Serializable)((Object)DEFAULT_PLACEMENT)));
    }

    public MarkerPopover(String id, IModel<Color> colorModel, PopoverPanel popoverPanel, IModel<String> titleModel, IModel<String> contentModel, IModel<LongLat> positionModel, IModel<String> placementModel) {
        super(id, colorModel);
        this.popoverPanel = popoverPanel;
        this.titleModel = titleModel;
        this.contentModel = contentModel;
        this.positionModel = positionModel;
        this.placementModel = placementModel;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{new AjaxEventBehavior("click"){

            protected void onEvent(AjaxRequestTarget target) {
                MarkerPopover.this.popoverPanel.getContentModel().setObject((Object)((String)MarkerPopover.this.getContentModel().getObject()));
                MarkerPopover.this.popoverPanel.getTitleModel().setObject((Object)((String)MarkerPopover.this.getTitleModel().getObject()));
                MarkerPopover.this.popoverPanel.setPosition((LongLat)MarkerPopover.this.positionModel.getObject());
                MarkerPopover.this.popoverPanel.setPlacement((String)MarkerPopover.this.getPlacementModel().getObject());
                MarkerPopover.this.popoverPanel.setPositioning(DEFAULT_POSITIONING);
                MarkerPopover.this.popoverPanel.show(target);
            }
        }});
    }

    public PopoverPanel getPopoverPanel() {
        return this.popoverPanel;
    }

    public IModel<String> getTitleModel() {
        return this.titleModel;
    }

    public IModel<String> getContentModel() {
        return this.contentModel;
    }

    public IModel<LongLat> getPositionModel() {
        return this.positionModel;
    }

    public IModel<String> getPlacementModel() {
        return this.placementModel;
    }
}

