/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3;

import com.google.gson.JsonArray;
import java.util.HashMap;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.wicketstuff.openlayers3.api.Extent;
import org.wicketstuff.openlayers3.api.Feature;
import org.wicketstuff.openlayers3.api.Map;
import org.wicketstuff.openlayers3.api.PersistentFeature;
import org.wicketstuff.openlayers3.api.geometry.Point;
import org.wicketstuff.openlayers3.api.interaction.Interaction;
import org.wicketstuff.openlayers3.api.layer.Layer;
import org.wicketstuff.openlayers3.api.layer.Vector;
import org.wicketstuff.openlayers3.api.source.vector.Cluster;
import org.wicketstuff.openlayers3.api.source.vector.VectorSource;
import org.wicketstuff.openlayers3.api.source.vector.loader.DefaultGeoJsonLoader;
import org.wicketstuff.openlayers3.api.source.vector.loader.VectorFeatureDataLoadedListener;
import org.wicketstuff.openlayers3.api.source.vector.loader.VectorFeaturesLoadedListener;

public abstract class OpenLayersMap
extends GenericPanel<Map> {
    private java.util.Map<Layer, VectorFeatureDataLoadedListener> layerDataLoadedMap = new HashMap<Layer, VectorFeatureDataLoadedListener>();
    private java.util.Map<Layer, VectorFeaturesLoadedListener> layerLoadedMap = new HashMap<Layer, VectorFeaturesLoadedListener>();

    public OpenLayersMap(String id, IModel<Map> model) {
        super(id, model);
    }

    protected void onConfigure() {
        super.onConfigure();
        Map map = (Map)this.getModelObject();
        map.setTarget(this.getMarkupId());
        if (map.getLayers() != null) {
            for (Layer layer : map.getLayers()) {
                if (!(layer instanceof Vector)) continue;
                final Vector vectorLayer = (Vector)layer;
                if (vectorLayer.getFeatureDataLoadedListeners() != null && vectorLayer.getFeatureDataLoadedListeners().size() > 0) {
                    VectorFeatureDataLoadedListener vectorFeatureDataLoadedListener = new VectorFeatureDataLoadedListener(vectorLayer){

                        @Override
                        public void handleDataLoaded(AjaxRequestTarget target, JsonArray features) {
                            vectorLayer.notifyFeatureDataLoadedListeners(target, features);
                        }
                    };
                    this.add(new Behavior[]{vectorFeatureDataLoadedListener});
                    this.layerDataLoadedMap.put(layer, vectorFeatureDataLoadedListener);
                }
                if (vectorLayer.getFeaturesLoadedListeners() == null || vectorLayer.getFeaturesLoadedListeners().size() <= 0) continue;
                VectorFeaturesLoadedListener vectorFeatureLoadedListener = new VectorFeaturesLoadedListener(vectorLayer){

                    @Override
                    public void handleDataLoaded(AjaxRequestTarget target) {
                        vectorLayer.notifyFeaturesLoadedListeners(target);
                    }
                };
                this.add(new Behavior[]{vectorFeatureLoadedListener});
                this.layerLoadedMap.put(layer, vectorFeatureLoadedListener);
            }
        }
    }

    public void zoomToFeatureExtent(AjaxRequestTarget target, Vector vector) {
        this.zoomToFeatureExtent(target, vector, 0);
    }

    public void zoomToFeatureExtent(AjaxRequestTarget target, Vector vector, Number buffer) {
        StringBuilder builder = new StringBuilder();
        builder.append("var points = [];");
        builder.append(vector.getJsId() + ".getSource().forEachFeature(function(feature) {");
        builder.append("  points.push(feature.getGeometry().getCoordinates());");
        builder.append("});");
        builder.append("var extent = ol.extent.boundingExtent(points);");
        builder.append("extent = ol.extent.buffer(extent, parseFloat('" + buffer + "'));");
        String jsId = ((Map)this.getModelObject()).getJsId();
        builder.append(jsId + ".getView().fit(extent, " + jsId + ".getSize());");
        target.appendJavaScript((CharSequence)builder.toString());
    }

    public void setViewCenter(AjaxRequestTarget target, Point point) {
        ((Map)this.getModelObject()).getView().setCenter(point.getCoordinate());
        target.appendJavaScript((CharSequence)("window.org_wicketstuff_openlayers3['map_" + this.getMarkupId() + "'].getView().setCenter(" + point.renderJs() + ");"));
    }

    public void addInteraction(AjaxRequestTarget target, Interaction interaction) {
        ((Map)this.getModelObject()).getInteractions().add(interaction);
        target.appendJavaScript((CharSequence)(interaction.getJsId() + " = new " + interaction.getJsType() + "(" + interaction.renderJs() + ");window.org_wicketstuff_openlayers3['map_" + this.getMarkupId() + "'].addInteraction(" + interaction.getJsId() + ");"));
    }

    public void removeInteraction(AjaxRequestTarget target, Interaction interaction) {
        ((Map)this.getModelObject()).getInteractions().remove(interaction);
        target.appendJavaScript((CharSequence)("window.org_wicketstuff_openlayers3['map_" + this.getMarkupId() + "'].removeInteraction(" + interaction.getJsId() + ");"));
    }

    public void zoomToExtent(AjaxRequestTarget target, Extent extent) {
        target.appendJavaScript((CharSequence)("window.org_wicketstuff_openlayers3['map_" + this.getMarkupId() + "'].getView().fit(" + ((Map)this.getModelObject()).getView().getExtent().renderJsForView(((Map)this.getModelObject()).getView()) + ",window.org_wicketstuff_openlayers3['map_" + this.getMarkupId() + "'].getSize());"));
    }

    public abstract void renderHead(IHeaderResponse var1);

    public String renderBeforeConstructorJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("if(typeof window.org_wicketstuff_openlayers3 === 'undefined') { window.org_wicketstuff_openlayers3 = []};\n\n");
        Map map = (Map)this.getModelObject();
        if (map != null) {
            for (Layer layer : map.getLayers()) {
                if (layer instanceof Vector) {
                    Vector vectorLayer = (Vector)layer;
                    VectorSource vectorSource = vectorLayer.getSource();
                    if (vectorSource.getFeatures() != null) {
                        for (Feature feature : vectorSource.getFeatures()) {
                            if (!(feature instanceof PersistentFeature)) continue;
                            builder.append(feature.getJsId() + " = new " + feature.getJsType() + "(" + feature.renderJs() + ");\n");
                        }
                    }
                    if (vectorSource.getLoader() != null) {
                        vectorSource.getLoader().setSource(vectorSource);
                    }
                    if (vectorSource instanceof Cluster) {
                        Cluster source = (Cluster)vectorSource;
                        builder.append(this.renderServerVectorJs(source.getSource(), layer));
                    }
                    builder.append(this.renderServerVectorJs(vectorSource, layer));
                }
                builder.append(layer.getJsId() + " = new " + layer.getJsType() + "(" + layer.renderJs() + ");\n");
            }
        }
        return builder.toString();
    }

    private String renderServerVectorJs(VectorSource vectorSource, Layer layer) {
        StringBuilder builder = new StringBuilder();
        builder.append(vectorSource.getJsId() + " = new " + vectorSource.getJsType() + "(" + vectorSource.renderJs() + ");\n");
        if (vectorSource.getLoader() instanceof DefaultGeoJsonLoader) {
            DefaultGeoJsonLoader loader = (DefaultGeoJsonLoader)vectorSource.getLoader();
            if (this.layerDataLoadedMap.get(layer) != null) {
                loader.vectorFeatureDataLoadedListener(this.layerDataLoadedMap.get(layer));
            }
            if (this.layerLoadedMap.get(layer) != null) {
                loader.vectorFeaturesLoadedListener(this.layerLoadedMap.get(layer));
            }
            builder.append(loader.renderBeforeConstructorJs() + ";\n");
        }
        return builder.toString();
    }

    public String renderAfterConstructorJs() {
        StringBuilder builder = new StringBuilder();
        Map map = (Map)this.getModelObject();
        if (map.getLayers() != null) {
            for (Layer layer : map.getLayers()) {
                Vector vectorLayer;
                VectorSource vectorSource;
                if (!(layer instanceof Vector) || (vectorSource = (vectorLayer = (Vector)layer).getSource()).getFeatures() == null) continue;
                for (Feature feature : vectorSource.getFeatures()) {
                    builder.append(feature.renderAfterConstructorJs());
                }
            }
        }
        return builder.toString();
    }

    public String renderAfterMapConstructorJs() {
        StringBuilder builder = new StringBuilder();
        Map map = (Map)this.getModelObject();
        if (map.getView().getExtent() != null) {
            builder.append(map.getJsId() + ".getView().fit(" + map.getView().getExtent().renderJsForView(map.getView()) + "," + map.getJsId() + ".getSize());");
        }
        return builder.toString();
    }

    public String renderJs() {
        Map map = (Map)this.getModelObject();
        StringBuilder builder = new StringBuilder();
        builder.append(this.renderBeforeConstructorJs() + "\n\n");
        builder.append(this.renderAfterConstructorJs());
        builder.append(map.getJsId() + " = new " + map.getJsType() + "(");
        builder.append(map.renderJs());
        builder.append(");\n\n");
        builder.append(this.renderAfterMapConstructorJs());
        return builder.toString();
    }

    public void updateLayers(AjaxRequestTarget target) {
        for (Layer layer : ((Map)this.getModelObject()).getLayers()) {
            layer.onUpdate(target);
        }
    }

    public void onDetach() {
        super.onDetach();
        Map map = (Map)this.getModel().getObject();
        for (Layer layer : map.getLayers()) {
            layer.detach();
        }
    }
}

