/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api;

import java.io.Serializable;
import org.wicketstuff.openlayers3.api.JavascriptObject;
import org.wicketstuff.openlayers3.api.View;
import org.wicketstuff.openlayers3.api.coordinate.LongLat;

public class Extent
extends JavascriptObject
implements Serializable {
    private LongLat maximum;
    private LongLat minimum;

    public LongLat getMinimum() {
        return this.minimum;
    }

    public void setMinimum(LongLat minimum) {
        this.minimum = minimum;
    }

    public Extent minimum(LongLat minimum) {
        this.setMinimum(minimum);
        return this;
    }

    public LongLat getMaximum() {
        return this.maximum;
    }

    public void setMaximum(LongLat maximum) {
        this.maximum = maximum;
    }

    public Extent maximum(LongLat maximum) {
        this.setMaximum(maximum);
        return this;
    }

    public String renderJsForView(View view) {
        StringBuilder builder = new StringBuilder();
        builder.append("ol.extent.boundingExtent([");
        builder.append(this.getMinimum().transform(view.getProjection()).renderJs());
        builder.append(",");
        builder.append(this.getMaximum().transform(view.getProjection()).renderJs());
        builder.append("])");
        return builder.toString();
    }

    @Override
    public String getJsType() {
        return "ol.Extent";
    }

    @Override
    public String renderJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.getMinimum().getX() + "," + this.getMinimum().getY() + ",");
        builder.append(this.getMaximum().getX() + "," + this.getMaximum().getY());
        builder.append("]");
        return builder.toString();
    }
}

