/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.openlayers3.api.JavascriptObject;
import org.wicketstuff.openlayers3.api.geometry.Point;
import org.wicketstuff.openlayers3.api.style.Style;

public class Feature
extends JavascriptObject
implements Serializable {
    private Point geometry;
    private String name;
    private Style style;
    private Map<String, String> stringValues;
    private Map<String, Number> numberValues;

    public Feature(Point geometry, String name) {
        this(geometry, name, null);
    }

    public Feature(Point geometry, String name, Style style) {
        this.geometry = geometry;
        this.name = name;
        this.style = style;
        this.stringValues = new HashMap<String, String>();
        this.numberValues = new HashMap<String, Number>();
    }

    public Point getGeometry() {
        return this.geometry;
    }

    public void setGeometry(Point geometry) {
        this.geometry = geometry;
    }

    public Feature geometry(Point geometry) {
        this.setGeometry(geometry);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Feature name(String name) {
        this.setName(name);
        return this;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Feature style(Style style) {
        this.setStyle(style);
        return this;
    }

    public Feature putString(String key, String value) {
        this.stringValues.put(key, value);
        return this;
    }

    public String getString(String key) {
        return this.stringValues.get(key);
    }

    public Feature putNumber(String key, Number value) {
        this.numberValues.put(key, value);
        return this;
    }

    public Number getNumber(String key) {
        return this.numberValues.get(key);
    }

    @Override
    public String getJsType() {
        return "ol.Feature";
    }

    public String renderAfterConstructorJs() {
        StringBuilder builder = new StringBuilder();
        if (this.getStyle() != null) {
            builder.append(this.getJsId());
            builder.append(".setStyle(new ");
            builder.append(this.getStyle().getJsType());
            builder.append("(" + this.getStyle().renderJs() + "));");
        }
        return builder.toString();
    }

    @Override
    public String renderJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("'id': \"" + this.getJsId() + "\",");
        if (this.getGeometry() != null) {
            builder.append("'geometry': new ");
            builder.append(this.geometry.getJsType());
            builder.append("(" + this.getGeometry().renderJs() + "),");
        }
        if (this.getName() != null) {
            builder.append("'name': '" + Strings.escapeMarkup((CharSequence)this.getName()).toString() + "',");
        }
        for (Map.Entry<String, String> entry : this.stringValues.entrySet()) {
            builder.append("'" + entry.getKey() + "': '" + Strings.escapeMarkup((CharSequence)entry.getValue()).toString() + "',");
        }
        for (Map.Entry<String, Object> entry : this.numberValues.entrySet()) {
            builder.append("'" + entry.getKey() + "': " + entry.getValue() + ",");
        }
        builder.append("}");
        return builder.toString();
    }
}

