/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.wicketstuff.openlayers3.api.JavascriptObject;
import org.wicketstuff.openlayers3.api.View;
import org.wicketstuff.openlayers3.api.interaction.Interaction;
import org.wicketstuff.openlayers3.api.layer.Layer;
import org.wicketstuff.openlayers3.api.overlay.Overlay;

public class Map
extends JavascriptObject
implements Serializable {
    private RenderType renderer;
    private List<Layer> layers = new ArrayList<Layer>();
    private List<Overlay> overlays = new ArrayList<Overlay>();
    private View view;
    private String target;
    private List<Interaction> interactions = new ArrayList<Interaction>();

    public Map(List<Layer> layers) {
        this((RenderType)null, layers, (View)null);
    }

    public Map(RenderType renderer, List<Layer> layers) {
        this(renderer, layers, null);
    }

    public Map(List<Layer> layers, View view) {
        this(null, layers, null, view);
    }

    public Map(RenderType renderer, List<Layer> layers, View view) {
        this(renderer, layers, null, view);
    }

    public Map(List<Layer> layers, List<Overlay> overlays, View view) {
        this(null, layers, overlays, view);
    }

    public Map(List<Layer> layers, List<Overlay> overlays) {
        this(null, layers, overlays, null);
    }

    public Map(RenderType renderer, List<Layer> layers, List<Overlay> overlays, View view) {
        this(renderer, layers, overlays, view, null);
    }

    public Map(RenderType renderer, List<Layer> layers, List<Overlay> overlays, View view, List<Interaction> interactions) {
        this.renderer = renderer;
        this.view = view;
        if (layers != null) {
            this.layers.addAll(layers);
        }
        if (overlays != null) {
            this.overlays.addAll(overlays);
        }
        if (interactions != null) {
            this.interactions.addAll(interactions);
        }
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public RenderType getRenderer() {
        return this.renderer;
    }

    public void setRenderer(RenderType renderer) {
        this.renderer = renderer;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public void setLayers(List<Layer> layers) {
        this.layers = new ArrayList<Layer>();
        if (layers != null) {
            this.layers.addAll(layers);
        }
    }

    public List<Overlay> getOverlays() {
        return this.overlays;
    }

    public void setOverlays(List<Overlay> overlays) {
        this.overlays = new ArrayList<Overlay>();
        if (overlays != null) {
            this.overlays.addAll(overlays);
        }
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public Map view(View view) {
        this.setView(view);
        return this;
    }

    public Map overlays(List<Overlay> overlays) {
        this.setOverlays(overlays);
        return this;
    }

    public Map renderer(RenderType renderer) {
        this.setRenderer(renderer);
        return this;
    }

    public Map Layers(List<Layer> layers) {
        this.setLayers(layers);
        return this;
    }

    public List<Interaction> getInteractions() {
        return this.interactions;
    }

    public void setInteractions(List<Interaction> interactions) {
        this.interactions = new ArrayList<Interaction>();
        if (interactions != null) {
            this.interactions.addAll(interactions);
        }
    }

    public Map interactions(List<Interaction> interactions) {
        this.setInteractions(interactions);
        return this;
    }

    @Override
    public String getJsType() {
        return "ol.Map";
    }

    @Override
    public String getJsId() {
        return "window.org_wicketstuff_openlayers3['map_" + this.getTarget() + "']";
    }

    @Override
    public String renderJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("'target': '" + this.getTarget() + "',");
        if (this.getRenderer() != null) {
            builder.append("'renderer': '" + this.getRenderer().toString() + "',");
        }
        if (this.getInteractions() != null && this.getInteractions().size() > 0) {
            builder.append("'interactions': ol.interaction.defaults().extend([");
            for (Interaction interaction : this.getInteractions()) {
                builder.append(interaction.getJsId() + " = new " + interaction.getJsType() + "(");
                builder.append(interaction.renderJs());
                builder.append("),");
            }
            builder.append("]),");
        }
        if (this.getLayers() != null && this.getLayers().size() > 0) {
            builder.append("'layers': [");
            for (Layer layer : this.getLayers()) {
                builder.append(layer.getJsId() + ",");
            }
            builder.append("],");
        }
        if (this.getOverlays() != null && this.getOverlays().size() > 0) {
            builder.append("'overlays': [");
            for (Overlay overlay : this.getOverlays()) {
                builder.append(overlay.getJsId() + " = new " + overlay.getJsType() + "(");
                builder.append(overlay.renderJs());
                builder.append("),");
            }
            builder.append("],");
        }
        if (this.getView() != null) {
            builder.append("'view': ");
            builder.append("new " + this.getView().getJsType() + "(");
            builder.append(this.getView().renderJs());
            builder.append("),");
        }
        builder.append("}");
        return builder.toString();
    }

    public static enum RenderType {
        Canvas("canvas"),
        Dom("dom"),
        WebGl("webgl");

        private String type;

        private RenderType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

