/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api;

import java.io.Serializable;
import org.wicketstuff.openlayers3.api.Extent;
import org.wicketstuff.openlayers3.api.JavascriptObject;
import org.wicketstuff.openlayers3.api.coordinate.Coordinate;

public class View
extends JavascriptObject
implements Serializable {
    public static final String DEFAULT_PROJECTION = "EPSG:3857";
    public Coordinate center;
    public Integer zoom;
    public Integer minZoom;
    public Integer maxZoom;
    public String projection;
    private Extent extent;

    public View(Coordinate center, Integer zoom) {
        this(center, zoom, null, DEFAULT_PROJECTION);
    }

    public View(Coordinate center, Integer zoom, Integer maxZoom) {
        this(center, zoom, maxZoom, DEFAULT_PROJECTION);
    }

    public View(Coordinate center, Integer zoom, String projection) {
        this(center, zoom, null, projection);
    }

    public View(Coordinate center, Integer zoom, Integer maxZoom, String projection) {
        this(center, zoom, maxZoom, projection, null);
    }

    public View(Coordinate center, Integer zoom, Integer maxZoom, String projection, Extent extent) {
        this.center = center;
        this.zoom = zoom;
        this.maxZoom = maxZoom;
        this.projection = projection;
        this.extent = extent;
    }

    public Coordinate getCenter() {
        return this.center;
    }

    public void setCenter(Coordinate center) {
        this.center = center;
    }

    public View center(Coordinate center) {
        this.setCenter(center);
        return this;
    }

    public Integer getZoom() {
        return this.zoom;
    }

    public void setZoom(Integer zoom) {
        this.zoom = zoom;
    }

    public View zoom(Integer zoom) {
        this.setZoom(zoom);
        return this;
    }

    public String getProjection() {
        return this.projection;
    }

    public void setProjection(String projection) {
        this.projection = projection;
    }

    public View projection(String projection) {
        this.setProjection(projection);
        return this;
    }

    public Integer getMinZoom() {
        return this.minZoom;
    }

    public void setMinZoom(Integer minZoom) {
        this.minZoom = minZoom;
    }

    public View minZoom(Integer minZoom) {
        this.setMaxZoom(minZoom);
        return this;
    }

    public Integer getMaxZoom() {
        return this.maxZoom;
    }

    public void setMaxZoom(Integer maxZoom) {
        this.maxZoom = maxZoom;
    }

    public View maxZoom(Integer maxZoom) {
        this.setMaxZoom(maxZoom);
        return this;
    }

    public Extent getExtent() {
        return this.extent;
    }

    public void setExtent(Extent extent) {
        this.extent = extent;
    }

    public View extent(Extent extent) {
        this.setExtent(extent);
        return this;
    }

    @Override
    public String getJsType() {
        return "ol.View";
    }

    @Override
    public String renderJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (this.getCenter() != null) {
            builder.append("'center': " + this.getCenter().renderJs() + ",");
        }
        if (this.getZoom() != null) {
            builder.append("'zoom': " + this.getZoom() + ",");
        }
        if (this.getMinZoom() != null) {
            builder.append("'minZoom': " + this.getMinZoom() + ",");
        }
        if (this.getMaxZoom() != null) {
            builder.append("'maxZoom': " + this.getMaxZoom() + ",");
        }
        if (this.getProjection() != null) {
            builder.append("'projection': '" + this.getProjection() + "',");
        }
        builder.append("}");
        return builder.toString();
    }
}

