/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.coordinate;

import org.wicketstuff.openlayers3.api.coordinate.Coordinate;

public class CoordinateProjected
extends Coordinate {
    private String projection;
    private String targetProjection = null;

    public CoordinateProjected(Number valueX, Number valueY, String projection) {
        super(valueX, valueY);
        this.projection = projection;
    }

    public CoordinateProjected(Number valueX, Number valueY, String projection, String targetProjection) {
        super(valueX, valueY);
        this.projection = projection;
        this.targetProjection = targetProjection;
    }

    public String getProjection() {
        return this.projection;
    }

    public void setProjection(String projection) {
        this.projection = projection;
    }

    public String getTargetProjection() {
        return this.targetProjection;
    }

    public void setTargetProjection(String targetProjection) {
        this.targetProjection = targetProjection;
    }

    public CoordinateProjected targetProjection(String targetProjection) {
        this.setTargetProjection(targetProjection);
        return this;
    }

    public CoordinateProjected transform(String targetProjection) {
        return this.targetProjection(targetProjection);
    }

    @Override
    public CoordinateProjected x(Number valueX) {
        this.setX(valueX);
        return this;
    }

    @Override
    public CoordinateProjected y(Number valueY) {
        this.setY(valueY);
        return this;
    }

    @Override
    public String renderJs() {
        if (this.targetProjection == null) {
            return super.renderJs();
        }
        return " ol.proj.transform(" + super.renderJs() + ", '" + this.getProjection() + "', '" + this.getTargetProjection() + "')";
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getProjection() + ",[" + this.getX() + "," + this.getY() + "]]";
    }
}

