/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.interaction;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.wicketstuff.openlayers3.api.Feature;
import org.wicketstuff.openlayers3.api.interaction.Interaction;
import org.wicketstuff.openlayers3.api.layer.Vector;
import org.wicketstuff.openlayers3.api.style.Style;

public class Modify
extends Interaction
implements Serializable {
    private Feature[] features;
    private Vector vector;
    private Style style;

    public Modify(Feature ... features) {
        this(new Style(), features);
    }

    public Modify(Style style, Feature ... features) {
        this(style, (Vector)null, features);
    }

    public Modify(Vector vector) {
        this(null, vector);
    }

    public Modify(Style style, Vector vector) {
        this(style, vector, (Feature[])null);
    }

    public Modify(Style style, Vector vector, Feature ... features) {
        this.features = features;
        this.vector = vector;
        this.style = style;
    }

    public Feature[] getFeatures() {
        return this.features;
    }

    public void setFeatures(Feature[] features) {
        this.features = features;
    }

    public Modify features(Feature[] features) {
        this.setFeatures(features);
        return this;
    }

    public Modify features(List<Feature> featuresList) {
        this.setFeatures(featuresList.toArray(new Feature[0]));
        return this;
    }

    public Vector getVector() {
        return this.vector;
    }

    public void setVector(Vector vector) {
        this.vector = vector;
    }

    public Modify vector(Vector vector) {
        this.setVector(vector);
        return this;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Modify style(Style style) {
        this.setStyle(style);
        return this;
    }

    public void changed(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)(this.getJsId() + ".changed();"));
    }

    @Override
    public String getJsType() {
        return "ol.interaction.Modify";
    }

    @Override
    public String renderJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(this.renderAttributesJs());
        builder.append("}");
        return builder.toString();
    }

    protected String renderAttributesJs() {
        StringBuilder builder = new StringBuilder();
        if (this.features != null && this.features.length > 0) {
            builder.append("'features': new ol.Collection([");
            for (Feature feature : this.features) {
                builder.append(feature.getJsId() + ",");
            }
            builder.append("]),");
        }
        if (this.vector != null) {
            builder.append("'features': new ol.Collection(");
            builder.append(this.vector.getJsId() + ".getSource().getFeatures()");
            builder.append("),");
        }
        if (this.style != null) {
            builder.append("'style': new " + this.style.getJsType() + "(" + this.style.renderJs() + "), ");
        } else {
            builder.append("'style': new ol.style.Style(), ");
        }
        return builder.toString();
    }
}

