/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.layer;

import java.io.Serializable;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.wicketstuff.openlayers3.api.JavascriptObject;

public abstract class Layer
extends JavascriptObject
implements Serializable {
    private IModel<Boolean> visibleModel;
    private IModel<? extends Number> opacityModel;

    public Layer() {
    }

    public Layer(IModel<Boolean> visibleModel) {
        this.visibleModel = visibleModel;
    }

    public void setVisible(AjaxRequestTarget target, boolean visible) {
        target.appendJavaScript((CharSequence)(this.getJsId() + ".setVisible(" + visible + ")"));
    }

    public void onUpdate(AjaxRequestTarget target) {
        if (this.visibleModel != null) {
            target.appendJavaScript((CharSequence)(this.getJsId() + ".setVisible(" + this.visibleModel.getObject() + ")"));
        }
        if (this.opacityModel != null) {
            target.appendJavaScript((CharSequence)(this.getJsId() + ".setOpacity(" + this.opacityModel.getObject() + ")"));
        }
    }

    public IModel<Boolean> getVisibleModel() {
        return this.visibleModel;
    }

    public Layer setVisibleModel(IModel<Boolean> visibleModel) {
        this.visibleModel = visibleModel;
        return this;
    }

    public IModel<? extends Number> getOpacityModel() {
        return this.opacityModel;
    }

    public Layer setOpacityModel(IModel<? extends Number> opacityModel) {
        this.opacityModel = opacityModel;
        return this;
    }

    public void detach() {
        if (this.visibleModel != null) {
            this.visibleModel.detach();
        }
        if (this.opacityModel != null) {
            this.opacityModel.detach();
        }
    }
}

