/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.layer;

import org.apache.wicket.model.IModel;
import org.wicketstuff.openlayers3.api.layer.Layer;
import org.wicketstuff.openlayers3.api.source.tile.TileSource;

public class Tile
extends Layer {
    private TileSource source;
    private String title;

    public Tile(TileSource source) {
        this(null, source);
    }

    public Tile(String title, TileSource source) {
        this.title = title;
        this.setSource(source);
    }

    public Tile(String title, TileSource source, IModel<Boolean> visibleModel) {
        super(visibleModel);
        this.title = title;
        this.setSource(source);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Tile title(String title) {
        this.setTitle(title);
        return this;
    }

    public TileSource getSource() {
        return this.source;
    }

    public void setSource(TileSource source) {
        this.source = source;
    }

    public Tile source(TileSource source) {
        this.setSource(source);
        return this;
    }

    @Override
    public String getJsType() {
        return "ol.layer.Tile";
    }

    @Override
    public String renderJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (this.title != null) {
            builder.append("'title': '" + this.getTitle() + "',");
        }
        if (this.getVisibleModel() != null) {
            builder.append("'visible': " + this.getVisibleModel().getObject() + ",");
        }
        builder.append("'source': new " + this.getSource().getJsType() + "(");
        builder.append(this.getSource().renderJs());
        builder.append(")");
        builder.append("}");
        return builder.toString();
    }
}

