/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.layer;

import com.google.gson.JsonArray;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.wicketstuff.openlayers3.api.layer.Layer;
import org.wicketstuff.openlayers3.api.layer.VectorFeatureDataLoadedListener;
import org.wicketstuff.openlayers3.api.layer.VectorFeaturesLoadedListener;
import org.wicketstuff.openlayers3.api.source.vector.VectorSource;
import org.wicketstuff.openlayers3.api.style.ClusterStyle;
import org.wicketstuff.openlayers3.api.style.Style;

public class Vector
extends Layer {
    private VectorSource source;
    private List<VectorFeatureDataLoadedListener> dataLoadedListeners = new ArrayList<VectorFeatureDataLoadedListener>();
    private List<VectorFeaturesLoadedListener> loadedListeners = new ArrayList<VectorFeaturesLoadedListener>();
    private Style style;
    private ClusterStyle clusterStyle;

    public Vector(VectorSource source) {
        this(source, null, null);
    }

    public Vector(VectorSource source, Style style) {
        this.setSource(source);
        this.style = style;
    }

    public Vector(VectorSource source, ClusterStyle clusterStyle) {
        this.setSource(source);
        this.clusterStyle = clusterStyle;
    }

    private Vector(VectorSource source, Style style, ClusterStyle clusterStyle) {
        this.setSource(source);
        this.style = style;
        this.clusterStyle = clusterStyle;
    }

    public VectorSource getSource() {
        return this.source;
    }

    public void setSource(VectorSource source) {
        this.source = source;
    }

    public Vector source(VectorSource source) {
        this.setSource(source);
        return this;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Vector style(Style style) {
        this.style = style;
        return this;
    }

    public Vector addFeatureDataLoadedListener(VectorFeatureDataLoadedListener listener) {
        this.dataLoadedListeners.add(listener);
        return this;
    }

    public Vector removeFeatureDataLoadedListener(VectorFeatureDataLoadedListener listener) {
        this.dataLoadedListeners.remove(listener);
        return this;
    }

    public Vector addFeaturesLoadedListener(VectorFeaturesLoadedListener listener) {
        this.loadedListeners.add(listener);
        return this;
    }

    public Vector removeFeaturesLoadedListener(VectorFeaturesLoadedListener listener) {
        this.loadedListeners.remove(listener);
        return this;
    }

    public List<VectorFeatureDataLoadedListener> getFeatureDataLoadedListeners() {
        return this.dataLoadedListeners;
    }

    public List<VectorFeaturesLoadedListener> getFeaturesLoadedListeners() {
        return this.loadedListeners;
    }

    public void notifyFeatureDataLoadedListeners(AjaxRequestTarget target, JsonArray features) {
        for (VectorFeatureDataLoadedListener listener : this.dataLoadedListeners) {
            listener.layerLoaded(target, this, features);
        }
    }

    public void notifyFeaturesLoadedListeners(AjaxRequestTarget target) {
        for (VectorFeaturesLoadedListener listener : this.loadedListeners) {
            listener.layerLoaded(target, this);
        }
    }

    @Override
    public String getJsType() {
        return "ol.layer.Vector";
    }

    @Override
    public String renderJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("'id': \"" + this.getJsId() + "\",");
        if (this.getSource() instanceof VectorSource) {
            builder.append("'source': " + this.getSource().getJsId() + ",");
        } else {
            builder.append("'source': new " + this.getSource().getJsType() + "(");
            builder.append(this.getSource().renderJs());
            builder.append("),");
        }
        if (this.style != null) {
            builder.append("'style': new " + this.getStyle().getJsType() + "(");
            builder.append(this.getStyle().renderJs());
            builder.append("),");
        }
        if (this.clusterStyle != null) {
            builder.append("'style': ");
            builder.append(this.clusterStyle.renderJs());
            builder.append(",");
        }
        builder.append("}");
        return builder.toString();
    }
}

