/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.overlay;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.wicketstuff.openlayers3.api.IJavascriptObject;
import org.wicketstuff.openlayers3.api.coordinate.LongLat;

public class Overlay
implements IJavascriptObject,
Serializable {
    public static final Positioning DEFAULT_POSITIONING = Positioning.TopLeft;
    public static final Boolean DEFAULT_STOP_EVENT = true;
    public LongLat position;
    public Positioning positioning;
    public Boolean stopEvent;
    protected Component element;

    public Overlay() {
        this(null, null, DEFAULT_POSITIONING, DEFAULT_STOP_EVENT);
    }

    public Overlay(LongLat position) {
        this(null, position, DEFAULT_POSITIONING, DEFAULT_STOP_EVENT);
    }

    public Overlay(Component component) {
        this(component, null, DEFAULT_POSITIONING, DEFAULT_STOP_EVENT);
    }

    public Overlay(Component component, LongLat position) {
        this(component, position, DEFAULT_POSITIONING, DEFAULT_STOP_EVENT);
    }

    public Overlay(Component component, Positioning positioning) {
        this(component, null, positioning, DEFAULT_STOP_EVENT);
    }

    public Overlay(Component component, LongLat position, Positioning positioning) {
        this(component, position, positioning, DEFAULT_STOP_EVENT);
    }

    public Overlay(Component component, LongLat position, Positioning positioning, Boolean stopEvent) {
        this.element = component;
        this.position = position;
        this.positioning = positioning;
        this.stopEvent = stopEvent;
    }

    public LongLat getPosition() {
        return this.position;
    }

    public void setPosition(LongLat position) {
        this.position = position;
    }

    public Overlay position(LongLat position) {
        this.setPosition(position);
        return this;
    }

    public Positioning getPositioning() {
        return this.positioning;
    }

    public void setPositioning(Positioning positioning) {
        this.positioning = positioning;
    }

    public Overlay positioning(Positioning positioning) {
        this.setPositioning(positioning);
        return this;
    }

    public Component getElement() {
        return this.element;
    }

    public void setElement(Component element) {
        this.element = element;
    }

    public Overlay element(Component element) {
        this.setElement(element);
        return this;
    }

    public Boolean getStopEvent() {
        return this.stopEvent;
    }

    public void setStopEvent(Boolean stopEvent) {
        this.stopEvent = stopEvent;
    }

    public Overlay stopEvent(Boolean stopEvent) {
        this.setStopEvent(stopEvent);
        return this;
    }

    @Override
    public String getJsId() {
        return "overlay_" + this.element.getMarkupId();
    }

    @Override
    public String getJsType() {
        return "ol.Overlay";
    }

    @Override
    public String renderJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(this.renderAttributesJs());
        builder.append("}");
        return builder.toString();
    }

    protected String renderAttributesJs() {
        StringBuilder builder = new StringBuilder();
        if (this.getElement() != null) {
            builder.append("'element': document.getElementById('" + this.element.getMarkupId() + "'),");
        }
        if (this.getPosition() != null) {
            builder.append("'position': " + this.position.renderJs() + ",");
        }
        if (this.getPositioning() != null) {
            builder.append("'positioning': '" + this.getPositioning() + "',");
        }
        return builder.toString();
    }

    protected String escapeQuoteJs(String text) {
        return text.replaceAll("'", "&apos;");
    }

    public static enum Positioning {
        BottomLeft("bottom-left"),
        BottomCenter("bottom-center"),
        BottomRight("bottom-right"),
        CenterLeft("center-left"),
        CenterCenter("center-center"),
        CenterRight("center-right"),
        TopLeft("top-left"),
        TopCenter("top-center"),
        TopRight("top-right");

        String value;

        private Positioning(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

