/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.proj;

import java.io.Serializable;
import org.wicketstuff.openlayers3.api.JavascriptObject;

public class Projection
extends JavascriptObject
implements Serializable {
    private static final String DEFAULT_UNITS = "degrees";
    private static final String DEFAULT_AXIS_ORIENTATION = "enu";
    private String code;
    private String units;
    private String axisOrientation;

    public Projection(String code) {
        this(code, DEFAULT_UNITS, DEFAULT_AXIS_ORIENTATION);
    }

    public Projection(String code, String units, String axisOrientation) {
        this.code = code;
        this.units = units;
        this.axisOrientation = axisOrientation;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Projection code(String code) {
        this.setCode(code);
        return this;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public Projection units(String units) {
        this.setUnits(units);
        return this;
    }

    public String getAxisOrientation() {
        return this.axisOrientation;
    }

    public void setAxisOrientation(String axisOrientation) {
        this.axisOrientation = axisOrientation;
    }

    public Projection axisOrientation(String axisOrientation) {
        this.setAxisOrientation(axisOrientation);
        return this;
    }

    @Override
    public String getJsType() {
        return "ol.proj.Projection";
    }

    @Override
    public String renderJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (this.code != null) {
            builder.append("'code': '" + this.code + "',");
        }
        if (this.units != null) {
            builder.append("'units': '" + this.units + "',");
        }
        if (this.units != null) {
            builder.append("'axisOrientation': '" + this.axisOrientation + "',");
        }
        builder.append("}");
        return builder.toString();
    }
}

