/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.source.tile;

import org.wicketstuff.openlayers3.api.source.tile.TileSource;

public class BingMaps
extends TileSource {
    private static final Culture DEFAULT_CULTURE = Culture.ENGLISH_US;
    private Culture culture;
    private String key;
    private ImagerySet imagerySet;

    public BingMaps(String key, ImagerySet imagerySet) {
        this(DEFAULT_CULTURE, key, imagerySet);
    }

    public BingMaps(Culture culture, String key, ImagerySet imagerySet) {
        this.culture = culture;
        this.key = key;
        this.imagerySet = imagerySet;
    }

    public Culture getCulture() {
        return this.culture;
    }

    public void setCulture(Culture culture) {
        this.culture = culture;
    }

    public BingMaps culture(Culture culture) {
        this.setCulture(culture);
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public BingMaps key(String key) {
        this.setKey(key);
        return this;
    }

    public ImagerySet getImagerySet() {
        return this.imagerySet;
    }

    public void setImagerySet(ImagerySet imagerySet) {
        this.imagerySet = imagerySet;
    }

    public BingMaps imagerySet(ImagerySet imagerySet) {
        this.setImagerySet(imagerySet);
        return this;
    }

    @Override
    public String getJsType() {
        return "ol.source.BingMaps";
    }

    @Override
    public String renderJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (this.getCulture() != null) {
            builder.append("'culture': '" + this.getCulture() + "',");
        }
        if (this.getKey() != null) {
            builder.append("'key': '" + this.getKey() + "',");
        }
        if (this.getImagerySet() != null) {
            builder.append("'imagerySet': '" + this.getImagerySet() + "',");
        }
        builder.append("}");
        return builder.toString();
    }

    public static enum ImagerySet {
        Aerial("Aerial"),
        AerialWithLabels("AerialWithLabels"),
        Road("Road"),
        OrdnanceSurvey("OrdnanceSurvey"),
        CollinsBart("CollinsBart");

        private String set;

        private ImagerySet(String set) {
            this.set = set;
        }

        public String toString() {
            return this.set;
        }
    }

    public static enum Culture {
        ENGLISH_US("en-US"),
        ENGLISH_UK("en-GB");

        private String code;

        private Culture(String code) {
            this.code = code;
        }

        public String toString() {
            return this.code;
        }
    }
}

