/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.source.tile;

import org.wicketstuff.openlayers3.api.source.tile.TileSource;
import org.wicketstuff.openlayers3.api.util.CorsPolicy;

public class TileJson
extends TileSource {
    private String url;
    private CorsPolicy crossOrigin;

    public TileJson(String url) {
        this(url, CorsPolicy.ANONYMOUS);
    }

    public TileJson(String url, CorsPolicy crossOrigin) {
        this.url = url;
        this.crossOrigin = crossOrigin;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public TileJson url(String url) {
        this.setUrl(url);
        return this;
    }

    public CorsPolicy getCrossOrigin() {
        return this.crossOrigin;
    }

    public void setCrossOrigin(CorsPolicy crossOrigin) {
        this.crossOrigin = crossOrigin;
    }

    public TileJson crossOrigin(CorsPolicy crossOrigin) {
        this.setCrossOrigin(crossOrigin);
        return this;
    }

    @Override
    public String getJsType() {
        return "ol.source.TileJSON";
    }

    @Override
    public String renderJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (this.url != null) {
            builder.append("'url': '" + this.url + "',");
        }
        if (this.crossOrigin != null) {
            builder.append("'crossOrigin': '" + this.crossOrigin + "',");
        }
        builder.append("}");
        return builder.toString();
    }
}

