/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.source.tile;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;
import org.wicketstuff.openlayers3.api.proj.Projection;
import org.wicketstuff.openlayers3.api.source.tile.TileSource;

public class TileWms
extends TileSource {
    private String url;
    private Map<String, String> params;
    private ServerType serverType;
    private Projection projection;

    public TileWms(String url, Map<String, String> params) {
        this.url = url;
        this.params = params;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public TileWms url(String url) {
        this.setUrl(url);
        return this;
    }

    public TileWms params(Map<String, String> params) {
        this.setParams(params);
        return this;
    }

    public TileWms serverType(ServerType serverType) {
        this.serverType = serverType;
        return this;
    }

    public TileWms projection(Projection projection) {
        this.projection = projection;
        return this;
    }

    public ServerType getServerType() {
        return this.serverType;
    }

    public void setServerType(ServerType serverType) {
        this.serverType = serverType;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    @Override
    public String getJsType() {
        return "ol.source.TileWMS";
    }

    @Override
    public String renderJs() {
        Gson gson = new GsonBuilder().create();
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("'url': '" + this.getUrl() + "',");
        if (this.serverType != null) {
            builder.append("'serverType': '" + this.serverType + "',");
        }
        if (this.getProjection() != null) {
            builder.append("'projection': new " + this.getProjection().getJsType() + "(" + this.getProjection().renderJs() + "),");
        }
        builder.append("'params': " + gson.toJson(this.getParams()) + ",");
        builder.append("}");
        return builder.toString();
    }

    public static enum ServerType {
        CARMENTASERVER("carmentaserver"),
        GEOSERVER("geoserver"),
        MAPSERVER("mapserver"),
        QGIS("qgis");

        String value;

        private ServerType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

