/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.source.vector;

import java.io.Serializable;
import java.util.List;
import org.wicketstuff.openlayers3.api.Feature;
import org.wicketstuff.openlayers3.api.JavascriptObject;
import org.wicketstuff.openlayers3.api.format.FeatureFormat;
import org.wicketstuff.openlayers3.api.proj.Projection;
import org.wicketstuff.openlayers3.api.source.vector.loader.Loader;

public class VectorSource
extends JavascriptObject
implements Serializable {
    private Projection projection;
    private FeatureFormat format;
    private Loader loader;
    private List<Feature> features;

    public VectorSource(List<Feature> features) {
        this(features, null, null, null);
    }

    public VectorSource(List<Feature> features, Projection projection) {
        this(features, null, null, projection);
    }

    public VectorSource(FeatureFormat format) {
        this(null, format, null, null);
    }

    public VectorSource(FeatureFormat format, Projection projection) {
        this(null, format, null, projection);
    }

    public VectorSource(FeatureFormat format, Loader loader, Projection projection) {
        this(null, format, loader, projection);
    }

    public VectorSource(List<Feature> features, FeatureFormat format, Loader loader, Projection projection) {
        this.features = features;
        this.projection = projection;
        this.format = format;
        this.loader = loader;
        if (this.loader != null) {
            this.loader.source(this);
        }
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public VectorSource features(List<Feature> features) {
        this.setFeatures(features);
        return this;
    }

    public VectorSource addFeature(Feature feature) {
        this.getFeatures().add(feature);
        return this;
    }

    public VectorSource removeFeature(Feature feature) {
        this.getFeatures().remove(feature);
        return this;
    }

    public FeatureFormat getFormat() {
        return this.format;
    }

    public void setFormat(FeatureFormat format) {
        this.format = format;
    }

    public VectorSource format(FeatureFormat format) {
        this.setFormat(format);
        return this;
    }

    public Loader getLoader() {
        return this.loader;
    }

    public void setLoader(Loader loader) {
        this.loader = loader;
        this.loader.source(this);
    }

    public VectorSource loader(Loader loader) {
        this.setLoader(loader);
        return this;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public VectorSource projection(Projection projection) {
        this.setProjection(projection);
        return this;
    }

    @Override
    public String getJsType() {
        return "ol.source.Vector";
    }

    @Override
    public String renderJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (this.getFeatures() != null) {
            builder.append("'features': [");
            for (Feature feature : this.getFeatures()) {
                builder.append(feature.getJsId());
                builder.append(",");
            }
            builder.append("],");
        }
        if (this.loader != null) {
            builder.append("'loader': " + this.loader.renderJs() + ",");
            builder.append("'strategy': ol.loadingstrategy.bbox,");
        }
        if (this.getProjection() != null) {
            builder.append("'projection': new " + this.getProjection().getJsType() + "(" + this.getProjection().renderJs() + "),");
        }
        builder.append("}");
        return builder.toString();
    }
}

