/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.source.vector.loader;

import java.io.Serializable;
import org.wicketstuff.openlayers3.api.source.vector.VectorSource;
import org.wicketstuff.openlayers3.api.source.vector.loader.Loader;
import org.wicketstuff.openlayers3.api.source.vector.loader.VectorFeatureDataLoadedListener;
import org.wicketstuff.openlayers3.api.source.vector.loader.VectorFeaturesLoadedListener;

public class DefaultGeoJsonLoader
extends Loader
implements Serializable {
    private String url;
    private String projection;
    private VectorFeatureDataLoadedListener vectorFeatureDataLoadedListener;
    private VectorFeaturesLoadedListener vectorFeaturesLoadedListener;

    public DefaultGeoJsonLoader(String url, String projection) {
        this.url = url;
        this.projection = projection;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public DefaultGeoJsonLoader url(String url) {
        this.setUrl(url);
        return this;
    }

    public String getProjection() {
        return this.projection;
    }

    public void setProjection(String projection) {
        this.projection = projection;
    }

    public DefaultGeoJsonLoader projection(String projection) {
        this.setProjection(projection);
        return this;
    }

    public VectorFeatureDataLoadedListener getVectorFeatureDataLoadedListener() {
        return this.vectorFeatureDataLoadedListener;
    }

    public void setVectorFeatureDataLoadedListener(VectorFeatureDataLoadedListener vectorFeatureDataLoadedListener) {
        this.vectorFeatureDataLoadedListener = vectorFeatureDataLoadedListener;
    }

    public DefaultGeoJsonLoader vectorFeatureDataLoadedListener(VectorFeatureDataLoadedListener vectorFeatureDataLoadedListener) {
        this.setVectorFeatureDataLoadedListener(vectorFeatureDataLoadedListener);
        return this;
    }

    public VectorFeaturesLoadedListener getVectorFeaturesLoadedListener() {
        return this.vectorFeaturesLoadedListener;
    }

    public void setVectorFeaturesLoadedListener(VectorFeaturesLoadedListener vectorFeaturesLoadedListener) {
        this.vectorFeaturesLoadedListener = vectorFeaturesLoadedListener;
    }

    public DefaultGeoJsonLoader vectorFeaturesLoadedListener(VectorFeaturesLoadedListener vectorFeaturesLoadedListener) {
        this.setVectorFeaturesLoadedListener(vectorFeaturesLoadedListener);
        return this;
    }

    @Override
    public DefaultGeoJsonLoader source(VectorSource source) {
        this.setSource(source);
        return this;
    }

    public String renderBeforeConstructorJs() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getJsIdWithSuffix("_loadFeatures") + " = function(response) {");
        builder.append("var format = new ol.format.GeoJSON(); \n");
        builder.append("var projectionFeatures = new ol.proj.Projection({'code': '" + this.projection + "','units': 'degress','axisOrientation': 'nue',}); \n");
        builder.append("var features  = format.readFeatures(response, { 'featureProjection': projectionFeatures }); \n");
        builder.append(this.getSource().getJsId() + ".addFeatures(features); \n");
        if (this.vectorFeatureDataLoadedListener != null) {
            builder.append(this.vectorFeatureDataLoadedListener.getCallbackFunctionName() + "(" + this.getSource().getJsId() + ");");
        }
        if (this.vectorFeaturesLoadedListener != null) {
            builder.append(this.vectorFeaturesLoadedListener.getCallbackFunctionName() + "(" + this.getSource().getJsId() + ");");
        }
        builder.append("};");
        return builder.toString();
    }

    @Override
    public String getJsType() {
        return "";
    }

    @Override
    public String renderJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("function(extent, resolution, projection) {\n");
        builder.append("var url = \"" + this.url + "&outputFormat=text/javascript");
        builder.append("&format_options=callback:" + this.getJsIdWithSuffix("_loadFeatures") + "&srsname=" + this.projection);
        builder.append("&bbox=\" + extent.join(\",\") + \"," + this.projection);
        builder.append("&srsname=" + this.projection + "\";\n");
        builder.append("$.ajax({ 'url': url, 'dataType': 'jsonp', 'jsonp': false, 'type': 'GET', 'async': false,}); \n");
        builder.append("}\n");
        return builder.toString();
    }
}

