/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.style;

import org.wicketstuff.openlayers3.api.style.Fill;
import org.wicketstuff.openlayers3.api.style.Image;
import org.wicketstuff.openlayers3.api.style.Stroke;
import org.wicketstuff.openlayers3.api.style.Style;
import org.wicketstuff.openlayers3.api.style.Text;

public class Circle
extends Style {
    private Number radius;
    private boolean snapToPixel;

    public Circle(Fill fill, Number radius, Stroke stroke) {
        this(fill, radius, true, stroke);
    }

    public Circle(Fill fill, Number radius, boolean snapToPixel, Stroke stroke) {
        super(fill, stroke);
        this.radius = radius;
        this.snapToPixel = snapToPixel;
    }

    @Override
    public Circle fill(Fill fill) {
        super.fill(fill);
        return this;
    }

    @Override
    public Circle image(Image image) {
        super.image(image);
        return this;
    }

    @Override
    public Circle stroke(Stroke stroke) {
        super.stroke(stroke);
        return this;
    }

    @Override
    public Circle text(Text text) {
        super.text(text);
        return this;
    }

    @Override
    public Style zIndex(Number zIndex) {
        super.zIndex(zIndex);
        return this;
    }

    public Number getRadius() {
        return this.radius;
    }

    public void setRadius(Number radius) {
        this.radius = radius;
    }

    public Circle radius(Number radius) {
        this.setRadius(radius);
        return this;
    }

    public boolean isSnapToPixel() {
        return this.snapToPixel;
    }

    public void setSnapToPixel(boolean snapToPixel) {
        this.snapToPixel = snapToPixel;
    }

    public Circle snapToPixel(boolean snapToPixel) {
        this.setSnapToPixel(snapToPixel);
        return this;
    }

    @Override
    public String getJsType() {
        return "ol.style.Circle";
    }

    @Override
    public String renderAttributesJs() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.renderAttributesJs());
        if (this.getRadius() != null) {
            builder.append("'radius': " + this.getRadius() + ",");
        }
        if (this.isSnapToPixel()) {
            builder.append("'snapToPixel': " + this.isSnapToPixel() + ",");
        }
        return builder.toString();
    }

    @Override
    public String renderJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(this.renderAttributesJs());
        builder.append("}");
        return builder.toString();
    }
}

