/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.style;

import org.wicketstuff.openlayers3.api.style.Circle;
import org.wicketstuff.openlayers3.api.style.Fill;
import org.wicketstuff.openlayers3.api.style.Image;
import org.wicketstuff.openlayers3.api.style.Stroke;
import org.wicketstuff.openlayers3.api.style.Style;
import org.wicketstuff.openlayers3.api.style.Text;

public class ClusterStyle
extends Style {
    public static final Integer DEFAULT_MINIMUM_RADIUS = 10;
    public static final Integer DEFAULT_MAXIMUM_RADIUS = 50;
    private Circle circle;
    private Number minimumRadius;
    private Number maximumRadius;

    public ClusterStyle(Circle circle, Text text) {
        this(circle, text, DEFAULT_MINIMUM_RADIUS, DEFAULT_MAXIMUM_RADIUS);
    }

    public ClusterStyle(Circle circle, Text text, Number minimumRadius, Number maximumRadius) {
        super(null, null, null, text, null);
        this.circle = circle;
        this.minimumRadius = minimumRadius;
        this.maximumRadius = maximumRadius;
        circle.setRadius(null);
        text.setText(null);
    }

    @Override
    public ClusterStyle fill(Fill fill) {
        super.fill(fill);
        return this;
    }

    @Override
    public ClusterStyle image(Image image) {
        super.image(image);
        return this;
    }

    @Override
    public ClusterStyle stroke(Stroke stroke) {
        super.stroke(stroke);
        return this;
    }

    @Override
    public ClusterStyle text(Text text) {
        super.text(text);
        return this;
    }

    @Override
    public ClusterStyle zIndex(Number zIndex) {
        super.zIndex(zIndex);
        return this;
    }

    public Circle getCircle() {
        return this.circle;
    }

    public void setCircle(Circle circle) {
        this.circle = circle;
    }

    public ClusterStyle circle(Circle circle) {
        this.setCircle(circle);
        return this;
    }

    public Number getMinimumRadius() {
        return this.minimumRadius;
    }

    public void setMinimumRadius(Number minimumRadius) {
        this.minimumRadius = minimumRadius;
    }

    public ClusterStyle minimumRadius(Number minimumRadius) {
        this.setMinimumRadius(minimumRadius);
        return this;
    }

    public Number getMaximumRadius() {
        return this.maximumRadius;
    }

    public void setMaximumRadius(Number maximumRadius) {
        this.maximumRadius = maximumRadius;
    }

    public ClusterStyle maximumRadius(Number maximumRadius) {
        this.setMaximumRadius(maximumRadius);
        return this;
    }

    @Override
    public String getJsType() {
        return "";
    }

    @Override
    public String renderAttributesJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("image: new " + this.circle.getJsType() + "({");
        builder.append(this.circle.renderAttributesJs());
        builder.append("'radius': sizeOut,");
        builder.append("}),");
        builder.append("text: new " + this.getText().getJsType() + "({");
        builder.append(this.getText().renderAttributesJs());
        builder.append("'text': size.toString(),");
        builder.append("}),");
        return builder.toString();
    }

    @Override
    public String renderJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("function(features, resolution) {");
        builder.append("  var size = features.get('features').length;");
        builder.append("  var sizeOut = size;");
        builder.append("  if(sizeOut < " + this.getMinimumRadius() + ") {");
        builder.append("    sizeOut = " + this.getMinimumRadius() + ";");
        builder.append("  } else if(sizeOut > " + this.getMaximumRadius() + ") {");
        builder.append("    sizeOut = " + this.getMaximumRadius() + ";");
        builder.append("  };");
        builder.append("  var style = [");
        builder.append("    new ol.style.Style({");
        builder.append(this.renderAttributesJs());
        builder.append("  })];");
        builder.append("  return style;");
        builder.append("}");
        return builder.toString();
    }
}

