/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.style;

import org.wicketstuff.openlayers3.api.coordinate.Coordinate;
import org.wicketstuff.openlayers3.api.style.Image;
import org.wicketstuff.openlayers3.api.util.CorsPolicy;

public class Icon
extends Image {
    public static final Coordinate DEFAULT_COORDINATE = new Coordinate(0.5, 0.5);
    private Coordinate anchor;
    private Origin anchorOrigin;
    private Unit anchorXUnits;
    private Unit anchorYUnits;
    private Number opacity;
    private String src;
    private CorsPolicy crossOrigin;

    public Icon(String src) {
        this(DEFAULT_COORDINATE, src);
    }

    public Icon(Coordinate anchor, String src) {
        this(anchor, Origin.TOP_LEFT, Unit.FRACTION, Unit.FRACTION, 1, src, null);
    }

    public Icon(Coordinate anchor, Origin anchorOrigin, Unit anchorXUnits, Unit anchorYUnits, Number opacity, String src, CorsPolicy crossOrigin) {
        this.anchor = anchor;
        this.anchorOrigin = anchorOrigin;
        this.anchorXUnits = anchorXUnits;
        this.anchorYUnits = anchorYUnits;
        this.opacity = opacity;
        this.src = src;
        this.crossOrigin = crossOrigin;
    }

    public Coordinate getAnchor() {
        return this.anchor;
    }

    public void setAnchor(Coordinate anchor) {
        this.anchor = anchor;
    }

    public Icon anchor(Coordinate anchor) {
        this.setAnchor(anchor);
        return this;
    }

    public Origin getAnchorOrigin() {
        return this.anchorOrigin;
    }

    public void setAnchorOrigin(Origin anchorOrigin) {
        this.anchorOrigin = anchorOrigin;
    }

    public Icon anchorOrigin(Origin anchorOrigin) {
        this.setAnchorOrigin(anchorOrigin);
        return this;
    }

    public Unit getAnchorXUnits() {
        return this.anchorXUnits;
    }

    public void setAnchorXUnits(Unit anchorXUnits) {
        this.anchorXUnits = anchorXUnits;
    }

    public Icon anchorXUnits(Unit anchorXUnits) {
        this.setAnchorXUnits(anchorXUnits);
        return this;
    }

    public Unit getAnchorYUnits() {
        return this.anchorYUnits;
    }

    public void setAnchorYUnits(Unit anchorYUnits) {
        this.anchorYUnits = anchorYUnits;
    }

    public Icon anchorYUnits(Unit anchorYUnits) {
        this.setAnchorYUnits(anchorYUnits);
        return this;
    }

    public Number getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Number opacity) {
        this.opacity = opacity;
    }

    public Icon opacity(Number opacity) {
        this.setOpacity(opacity);
        return this;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public Icon src(String src) {
        this.setSrc(src);
        return this;
    }

    public CorsPolicy getCrossOrigin() {
        return this.crossOrigin;
    }

    public void setCrossOrigin(CorsPolicy crossOrigin) {
        this.crossOrigin = crossOrigin;
    }

    public Icon crossOrigin(CorsPolicy crossOrigin) {
        this.setCrossOrigin(crossOrigin);
        return this;
    }

    @Override
    public Icon rotation(Number number) {
        super.rotation(number);
        return this;
    }

    @Override
    public Icon scale(Number scale) {
        super.scale(scale);
        return this;
    }

    @Override
    public String getJsType() {
        return "ol.style.Icon";
    }

    @Override
    public String renderJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(super.renderAttributesJs());
        if (this.getAnchor() != null) {
            builder.append("'anchor': " + this.getAnchor().renderJs() + ",");
        }
        if (this.getAnchorOrigin() != null) {
            builder.append("'anchorOrigin': '" + this.getAnchorOrigin() + "',");
        }
        if (this.getAnchorXUnits() != null) {
            builder.append("'anchorXUnits': '" + this.getAnchorXUnits() + "',");
        }
        if (this.getAnchorYUnits() != null) {
            builder.append("'anchorYUnits': '" + this.getAnchorYUnits() + "',");
        }
        if (this.getOpacity() != null) {
            builder.append("'opacity': " + this.getOpacity() + ",");
        }
        if (this.getSrc() != null) {
            builder.append("'src': '" + this.getSrc() + "',");
        }
        if (this.getCrossOrigin() != null) {
            builder.append("'cross-origin': '" + this.getCrossOrigin() + "',");
        }
        builder.append("}");
        return builder.toString();
    }

    public static enum Unit {
        FRACTION("fraction"),
        PIXEL("pixels");

        String value;

        private Unit(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Origin {
        BOTTOM_LEFT("bottom-left"),
        BOTTOM_RIGHT("bottom-right"),
        TOP_LEFT("top-left"),
        TOP_RIGHT("top-right");

        String value;

        private Origin(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

