/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.style;

import java.io.Serializable;
import org.wicketstuff.openlayers3.api.JavascriptObject;
import org.wicketstuff.openlayers3.api.util.Color;
import org.wicketstuff.openlayers3.api.util.Joiner;

public class Stroke
extends JavascriptObject
implements Serializable {
    private static final LineCap DEFAULT_LINE_CAP = LineCap.ROUND;
    private static final LineCap DEFAULT_LINE_JOIN = LineCap.ROUND;
    private static final Integer DEFAULT_MITER_LIMIT = 10;
    private Color color;
    private LineCap lineCap;
    private LineCap lineJoin;
    private Number[] lineDash;
    private Number miterLimit;
    private Number width;

    public Stroke(String color) {
        this(new Color(color));
    }

    public Stroke(Color color) {
        this(color, DEFAULT_LINE_CAP, DEFAULT_LINE_JOIN, null, DEFAULT_MITER_LIMIT, null);
    }

    public Stroke(Color color, LineCap lineCap, LineCap lineJoin, Number[] lineDash, Number miterLimit, Number width) {
        this.color = color;
        this.lineCap = lineCap;
        this.lineJoin = lineJoin;
        this.lineDash = lineDash;
        this.miterLimit = miterLimit;
        this.width = width;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Stroke color(Color color) {
        this.setColor(color);
        return this;
    }

    public LineCap getLineCap() {
        return this.lineCap;
    }

    public void setLineCap(LineCap lineCap) {
        this.lineCap = lineCap;
    }

    public Stroke lineCap(LineCap lineCap) {
        this.setLineCap(lineCap);
        return this;
    }

    public LineCap getLineJoin() {
        return this.lineJoin;
    }

    public void setLineJoin(LineCap lineJoin) {
        this.lineJoin = lineJoin;
    }

    public Stroke lineJoin(LineCap lineJoin) {
        this.setLineJoin(lineJoin);
        return this;
    }

    public Number[] getLineDash() {
        return this.lineDash;
    }

    public void setLineDash(Number ... lineDash) {
        this.lineDash = lineDash;
    }

    public Stroke lineDash(Number ... lineDash) {
        this.setLineDash(lineDash);
        return this;
    }

    public Number getMiterLimit() {
        return this.miterLimit;
    }

    public void setMiterLimit(Number miterLimit) {
        this.miterLimit = miterLimit;
    }

    public Stroke miterLimit(Number miterLimit) {
        this.setMiterLimit(miterLimit);
        return this;
    }

    public Number getWidth() {
        return this.width;
    }

    public void setWidth(Number width) {
        this.width = width;
    }

    public Stroke width(Number width) {
        this.setWidth(width);
        return this;
    }

    @Override
    public String getJsType() {
        return "ol.style.Stroke";
    }

    public String renderAttributesJs() {
        StringBuilder builder = new StringBuilder();
        if (this.getColor() != null) {
            builder.append("'color': " + this.getColor().renderJs() + ",");
        }
        if (this.getLineCap() != null) {
            builder.append("'lineCap': '" + this.getLineCap() + "',");
        }
        if (this.getLineJoin() != null) {
            builder.append("'lineJoin': '" + this.getLineJoin() + "',");
        }
        if (this.getLineDash() != null) {
            builder.append("'lineDash': [" + Joiner.join(",", this.lineDash) + "],");
        }
        if (this.getMiterLimit() != null) {
            builder.append("'miterLimit': " + this.getMiterLimit() + ",");
        }
        if (this.getWidth() != null) {
            builder.append("'width': " + this.getWidth() + ",");
        }
        return builder.toString();
    }

    @Override
    public String renderJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(this.renderAttributesJs());
        builder.append("}");
        return builder.toString();
    }

    public static enum LineCap {
        BUTT("butt"),
        ROUND("round"),
        SQUARE("square");

        String value;

        private LineCap(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

