/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.style;

import java.io.Serializable;
import org.wicketstuff.openlayers3.api.JavascriptObject;
import org.wicketstuff.openlayers3.api.style.Fill;
import org.wicketstuff.openlayers3.api.style.Stroke;

public class Text
extends JavascriptObject
implements Serializable {
    public String font;
    public Number offsetX;
    public Number offsetY;
    public Number scale;
    public Number rotation;
    public String text;
    public String textAlign;
    public String textBaseLine;
    public Fill fill;
    public Stroke stroke;

    public Text(String text, Fill fill) {
        this(null, 0, 0, null, null, text, null, null, fill, null);
    }

    public Text(String font, Number offsetX, Number offsetY, Number scale, Number rotation, String text, String textAlign, String textBaseLine, Fill fill, Stroke stroke) {
        this.font = font;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.textAlign = textAlign;
        this.textBaseLine = textBaseLine;
        this.fill = fill;
        this.scale = scale;
        this.rotation = rotation;
        this.text = text;
    }

    public String getFont() {
        return this.font;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public Number getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(Number offsetX) {
        this.offsetX = offsetX;
    }

    public Number getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(Number offsetY) {
        this.offsetY = offsetY;
    }

    public Number getScale() {
        return this.scale;
    }

    public void setScale(Number scale) {
        this.scale = scale;
    }

    public Number getRotation() {
        return this.rotation;
    }

    public void setRotation(Number rotation) {
        this.rotation = rotation;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(String textAlign) {
        this.textAlign = textAlign;
    }

    public String getTextBaseLine() {
        return this.textBaseLine;
    }

    public void setTextBaseLine(String textBaseLine) {
        this.textBaseLine = textBaseLine;
    }

    public Fill getFill() {
        return this.fill;
    }

    public void setFill(Fill fill) {
        this.fill = fill;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public String getJsType() {
        return "ol.style.Text";
    }

    public String renderAttributesJs() {
        StringBuilder builder = new StringBuilder();
        if (this.getFont() != null) {
            builder.append("'font': '" + this.getFont() + "',");
        }
        if (this.getOffsetX() != null) {
            builder.append("'offsetX': " + this.getOffsetX() + ",");
        }
        if (this.getOffsetY() != null) {
            builder.append("'offsetY': " + this.getOffsetY() + ",");
        }
        if (this.getScale() != null) {
            builder.append("'scale': " + this.getScale() + ",");
        }
        if (this.getRotation() != null) {
            builder.append("'rotation': " + this.getRotation() + ",");
        }
        if (this.getText() != null) {
            builder.append("'text': '" + this.escapeQuoteJs(this.getText()) + "',");
        }
        if (this.getTextBaseLine() != null) {
            builder.append("'textBaseline': '" + this.getTextBaseLine() + "',");
        }
        if (this.getTextAlign() != null) {
            builder.append("'textAlign': '" + this.getTextAlign() + "',");
        }
        if (this.getFill() != null) {
            builder.append("'fill': new " + this.getFill().getJsType());
            builder.append("(" + this.getFill().renderJs() + "),");
        }
        if (this.getStroke() != null) {
            builder.append("'stroke': new " + this.getStroke().getJsType());
            builder.append("(" + this.getStroke().renderJs() + "),");
        }
        return builder.toString();
    }

    @Override
    public String renderJs() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(this.renderAttributesJs());
        builder.append("}");
        return builder.toString();
    }
}

