/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.api.util;

import java.io.Serializable;

public class Color
implements Serializable {
    public int red;
    public int green;
    public int blue;
    public double alpha;

    public Color(String hexValue) {
        String parsedValue = hexValue;
        if (parsedValue.charAt(0) == '#') {
            parsedValue = parsedValue.substring(1);
        }
        if (parsedValue.length() != 6) {
            throw new IllegalArgumentException("Not a valid web color code");
        }
        String redHexValue = parsedValue.substring(0, 2);
        String greenHexValue = parsedValue.substring(2, 4);
        String blueHexValue = parsedValue.substring(4, 6);
        this.red = Integer.parseInt(redHexValue, 16);
        this.green = Integer.parseInt(greenHexValue, 16);
        this.blue = Integer.parseInt(blueHexValue, 16);
        this.alpha = 1.0;
    }

    public Color(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = 1.0;
    }

    public Color(int red, int green, int blue, double alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public int getRed() {
        return this.red;
    }

    public void setRed(int red) {
        this.red = red;
    }

    public Color red(int red) {
        this.setRed(red);
        return this;
    }

    public int getGreen() {
        return this.green;
    }

    public void setGreen(int green) {
        this.green = green;
    }

    public Color green(int green) {
        this.setGreen(green);
        return this;
    }

    public int getBlue() {
        return this.blue;
    }

    public void setBlue(int blue) {
        this.blue = blue;
    }

    public Color blue(int blue) {
        this.setBlue(blue);
        return this;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public Color alpha(double alpha) {
        this.setAlpha(alpha);
        return this;
    }

    public String renderJs() {
        return "[" + this.red + "," + this.green + "," + this.blue + "," + this.alpha + "]";
    }

    public String toString() {
        return "rgba(" + this.red + "," + this.green + "," + this.blue + "," + this.alpha + ")";
    }
}

