/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.behavior;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.openlayers3.api.coordinate.LongLat;
import org.wicketstuff.openlayers3.api.util.HeaderUtils;

public abstract class ClickFeatureHandler
extends AbstractDefaultAjaxBehavior {
    public static final String DEFAULT_PROJECTION = "EPSG:4326";
    public static Long counter = 0L;
    private final String projection;

    public ClickFeatureHandler() {
        this(DEFAULT_PROJECTION);
    }

    public ClickFeatureHandler(String projection) {
        this.projection = projection;
    }

    public abstract void handleClick(AjaxRequestTarget var1, String var2, LongLat var3, JsonObject var4);

    public void handleClickMiss(AjaxRequestTarget target, LongLat longLat) {
    }

    protected void respond(AjaxRequestTarget target) {
        IRequestParameters params = RequestCycle.get().getRequest().getRequestParameters();
        String coordinateRaw = params.getParameterValue("coordinate").toString();
        String featureId = params.getParameterValue("id").toString();
        String properties = params.getParameterValue("properties").toString();
        JsonObject propertiesJson = null;
        JsonElement propertiesParsed = new JsonParser().parse(properties);
        if (!(propertiesParsed instanceof JsonNull)) {
            propertiesJson = propertiesParsed.getAsJsonObject();
        }
        String[] coordinates = Strings.split((String)coordinateRaw, (char)',');
        Double longitude = Double.parseDouble(coordinates[0]);
        Double latitude = Double.parseDouble(coordinates[1]);
        if (!properties.isEmpty()) {
            this.handleClick(target, featureId, new LongLat(longitude, latitude, this.projection), propertiesJson);
        } else {
            this.handleClickMiss(target, new LongLat(longitude, latitude, this.projection));
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        HashMap<String, CharSequence> params = new HashMap<String, CharSequence>();
        params.put("callbackUrl", this.getCallbackUrl());
        Long l = counter;
        Long l2 = counter = Long.valueOf(counter + 1L);
        params.put("clickHandlerId", l.toString());
        params.put("componentId", component.getMarkupId());
        params.put("projection", this.projection != null ? this.projection : "NULL");
        HeaderUtils.renderOnDomReady(response, ClickFeatureHandler.class, "ClickFeatureHandler.js", params);
    }
}

